/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mobile.controller;

import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.common.resource.mapper.SqlMapper;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dir2"})
public class MobileLogicResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileLogicResourceController.class);
    private static final Map<String, String> xmls = new HashMap<String, String>();
    private final LogicMapper logicMapper;
    private final SqlMapper sqlMapper;

    public MobileLogicResourceController(LogicMapper logicMapper, SqlMapper sqlMapper) {
        this.logicMapper = logicMapper;
        this.sqlMapper = sqlMapper;
    }

    @Log(title="getFiles", businessType=BusinessType.OTHER)
    @GetMapping(produces={"application/json"})
    public String getFiles() {
        Object result = "";
        result = (String)result + this.getLogicMap(true);
        result = (String)result + "|" + this.getSqlMap(true);
        return result;
    }

    @Log(title="getFilesNoXML", businessType=BusinessType.OTHER)
    @GetMapping(value={"/noxml"}, produces={"application/json"})
    public String getFilesNoXML() {
        String result = "";
        result = this.union(result, this.getLogicMap(false), "|");
        result = this.union(result, this.getSqlMap(false), "|");
        return result;
    }

    @Log(title="getFile", businessType=BusinessType.OTHER)
    @PostMapping(produces={"application/json"})
    public String getFile(String fileName) {
        ResourceType resourceType;
        LogicMapper.LogicResource commonResource;
        if (fileName.endsWith(".xml")) {
            String type = fileName.substring(0, fileName.length() - 4);
            return xmls.get(type);
        }
        String name = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.lastIndexOf("."));
        if (fileName.endsWith("logic")) {
            commonResource = this.logicMapper.getValue(name);
            resourceType = ResourceType.LOGIC;
        } else {
            commonResource = this.sqlMapper.getValue(name);
            resourceType = ResourceType.SQL;
        }
        String path = (String)commonResource.getPath();
        name = commonResource.getAlias();
        return ResourceIndexer.getString((ResourceType)resourceType, (String)name, (String)path);
    }

    private String getLogicMap(boolean hasXml) {
        Map logicmap = this.logicMapper.getAllMap();
        return this.getMap(logicmap, "logic", hasXml);
    }

    private String getSqlMap(boolean hasXml) {
        Map logicmap = this.sqlMapper.getAllMap();
        return this.getMap(logicmap, "sql", hasXml);
    }

    private String getMap(Map<String, Map<String, String>> logicmap, String type, boolean hasXml) {
        StringBuilder result = new StringBuilder();
        StringBuilder xml = new StringBuilder("<cfg>");
        for (Map.Entry<String, Map<String, String>> entry : logicmap.entrySet()) {
            ResourceType resourceType;
            if (!"true".equals(entry.getValue().get("mobile"))) continue;
            if (!result.toString().equals("")) {
                result.append("|");
            }
            Object file = entry.getKey();
            String path = entry.getValue().get("path");
            if (type.equals("logic")) {
                file = "logics/" + (String)file + ".logic";
                resourceType = ResourceType.LOGIC;
            } else {
                file = "sqls/" + (String)file + ".sql";
                resourceType = ResourceType.SQL;
            }
            result.append((String)file).append(",").append(this.getMD5(resourceType, entry.getValue().get("name"), path));
            file = ((String)file).substring(((String)file).indexOf("/") + 1);
            xml.append("<").append(type).append(" alias='").append(entry.getKey()).append("' path='").append((String)file).append("' />");
        }
        xml.append("</cfg>");
        if (!xmls.containsKey(type)) {
            xmls.put(type, xml.toString());
        }
        if (!hasXml) {
            return result.toString();
        }
        if (!result.toString().equals("")) {
            result.append("|");
        }
        result.append("/").append(type).append(".xml").append(",").append(this.getStringMD5(xml.toString()));
        return result.toString();
    }

    private String getMD5(ResourceType resourceType, String name, String path) {
        String str = ResourceIndexer.getString((ResourceType)resourceType, (String)name, (String)path);
        return this.getStringMD5(str);
    }

    private String getStringMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException("md5\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private String union(String str1, String str2, String ch) {
        if (str1 == null || str1.equals("")) {
            return str2;
        }
        if (str2 == null || str2.equals("")) {
            return str1;
        }
        return str1 + ch + str2;
    }
}

