/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mobile.controller;

import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/db"})
public class MobileEntitySyncController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileEntitySyncController.class);
    private final EntityService entityService;
    private final SessionPool sessionPool;

    public MobileEntitySyncController(EntityService entityService, SessionPool sessionPool) {
        this.entityService = entityService;
        this.sessionPool = sessionPool;
    }

    @Log(title="meta2", businessType=BusinessType.OTHER)
    @PostMapping(value={"/meta2"}, produces={"application/json"})
    public String getMetaOfTables() {
        this.entityService.loadMetaData();
        Map leftMap = EntityService.getEntityLiftMap();
        Map metaMap = EntityService.getMetaMap();
        HashMap map = new HashMap();
        for (String key : leftMap.keySet()) {
            map.put(key, leftMap.get(key));
        }
        metaMap.put("_entityLiftMap_", map);
        return new JSONObject(metaMap).toString();
    }

    @Log(title="meta", businessType=BusinessType.OTHER)
    @PostMapping(value={"/meta"}, produces={"application/json"})
    public String getMetaOfTables(String tables) {
        return this.getMeta(tables).toString();
    }

    public JSONObject getMeta(String entityName) {
        String[] entities = entityName.split(",");
        JSONObject result = new JSONObject();
        for (String entity : entities) {
            JSONArray associations = new JSONArray();
            JSONArray columns = new JSONArray();
            SessionFactoryImpl sessionFactory = this.sessionPool.getSessionFactory();
            ClassMetadata cmd = sessionFactory.getClassMetadata(entity);
            JSONObject joProperties = new JSONObject();
            joProperties.put("__table__", (Object)this.removeSchema(((AbstractEntityPersister)cmd).getTableName()));
            joProperties.put("__columns__", (Object)columns);
            for (String property : cmd.getPropertyNames()) {
                Type type = cmd.getPropertyType(property);
                if (type instanceof CollectionType) {
                    CollectionType st = (CollectionType)type;
                    Joinable ja = st.getAssociatedJoinable((SessionFactoryImplementor)sessionFactory);
                    String idName = cmd.getIdentifierPropertyName();
                    Type idType = cmd.getIdentifierType();
                    JSONObject jo = new JSONObject();
                    jo.put("entity", (Object)entity);
                    jo.put("table", (Object)this.removeSchema(((AbstractEntityPersister)cmd).getTableName()));
                    jo.put("key", (Object)idName);
                    jo.put("type", (Object)idType.getName());
                    jo.put("collection", (Object)ja.getName().substring(entity.length() + 1));
                    EntityPersister ps = sessionFactory.getMetamodel().entityPersister(entity);
                    CascadeStyle[] ccs = ps.getPropertyCascadeStyles();
                    StringBuilder ccsOptions = new StringBuilder();
                    for (CascadeStyle cs : ccs) {
                        ccsOptions.append(",").append(cs);
                    }
                    jo.put("cascade", (Object)(ccsOptions.length() > 0 ? ccsOptions.substring(1).replace("STYLE_NONE,", "").replace("[", "").replace("]", "") : ""));
                    String[] foreignKeys = ja.getKeyColumnNames();
                    jo.put("entity2", (Object)st.getAssociatedEntityName((SessionFactoryImplementor)sessionFactory));
                    jo.put("table2", (Object)this.removeSchema(ja.getTableName()));
                    jo.put("key2", (Object)foreignKeys[0]);
                    associations.put((Object)jo);
                    continue;
                }
                if (type instanceof ManyToOneType) continue;
                String columnName = ((AbstractEntityPersister)cmd).getPropertyColumnNames(property)[0];
                JSONObject colJo = new JSONObject();
                colJo.put("attr", (Object)property);
                colJo.put("column", (Object)columnName);
                colJo.put("type", (Object)type.getName());
                columns.put((Object)colJo);
                joProperties.put(columnName, (Object)type.getName());
            }
            String idName = cmd.getIdentifierPropertyName();
            Type idType = cmd.getIdentifierType();
            JSONObject jp = new JSONObject();
            jp.put("id", (Object)idName);
            jp.put("type", (Object)idType.getName());
            joProperties.put("__primary__key__", (Object)jp);
            joProperties.put(idName, (Object)idType.getName());
            joProperties.put("__associations__", (Object)associations);
            result.put(entity, (Object)joProperties);
        }
        return result;
    }

    private String removeSchema(String tableName) {
        if (tableName.contains(".")) {
            return tableName.substring(tableName.indexOf(46) + 1);
        }
        return tableName;
    }
}

