/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mobile.controller;

import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.common.resource.mapper.SqlMapper;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dir2"})
public class MobileLogicResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileLogicResourceController.class);
    private static final Map<String, String> xmls = new HashMap<String, String>();
    private final LogicMapper logicMapper;
    private final SqlMapper sqlMapper;

    public MobileLogicResourceController(LogicMapper logicMapper, SqlMapper sqlMapper) {
        this.logicMapper = logicMapper;
        this.sqlMapper = sqlMapper;
    }

    @Log(title="getFiles", businessType=BusinessType.OTHER)
    @GetMapping(produces={"application/json"})
    public String getFiles() {
        Object result = "";
        result = (String)result + this.getLogicMap(true);
        result = (String)result + "|" + this.getSqlMap(true);
        return result;
    }

    @Log(title="getFilesNoXML", businessType=BusinessType.OTHER)
    @GetMapping(value={"/noxml"}, produces={"application/json"})
    public String getFilesNoXML() {
        String result = "";
        result = this.union(result, this.getLogicMap(false), "|");
        result = this.union(result, this.getSqlMap(false), "|");
        return result;
    }

    @Log(title="getFile", businessType=BusinessType.OTHER)
    @PostMapping(produces={"application/json"})
    public String getFile(String fileName) {
        if (fileName.endsWith(".xml")) {
            String type = fileName.substring(0, fileName.length() - 4);
            return xmls.get(type);
        }
        String name = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.lastIndexOf("."));
        Object mapper = fileName.endsWith(ResourceType.LOGIC.getValue()) ? this.logicMapper : this.sqlMapper;
        return mapper.getResource(name).getSource();
    }

    private String getLogicMap(boolean hasXml) {
        Map logicMap = this.logicMapper.getAllMap();
        return this.getMap(logicMap, ResourceType.LOGIC, hasXml);
    }

    private String getSqlMap(boolean hasXml) {
        Map sqlMap = this.sqlMapper.getAllMap();
        return this.getMap(sqlMap, ResourceType.SQL, hasXml);
    }

    private String getMap(Map<String, ? extends AbstractResourceMapper.MobileResourceSupport> resMap, ResourceType type, boolean hasXml) {
        StringBuilder result = new StringBuilder();
        StringBuilder xml = new StringBuilder("<cfg>");
        for (Map.Entry<String, ? extends AbstractResourceMapper.MobileResourceSupport> entry : resMap.entrySet()) {
            if (!entry.getValue().isMobile()) continue;
            AbstractResourceMapper.CommonResource resource = (AbstractResourceMapper.CommonResource)entry.getValue();
            if (!result.toString().isEmpty()) {
                result.append("|");
            }
            Object file = entry.getKey();
            file = type.getValue() + "s/" + (String)file + "." + type.getValue();
            result.append((String)file).append(",").append(this.getMD5(resource));
            file = ((String)file).substring(((String)file).indexOf("/") + 1);
            xml.append("<").append(type).append(" alias='").append(entry.getKey()).append("' path='").append((String)file).append("' />");
        }
        xml.append("</cfg>");
        if (!xmls.containsKey(type.getValue())) {
            xmls.put(type.getValue(), xml.toString());
        }
        if (!hasXml) {
            return result.toString();
        }
        if (!result.toString().isEmpty()) {
            result.append("|");
        }
        result.append("/").append(type).append(".xml").append(",").append(this.getStringMD5(xml.toString()));
        return result.toString();
    }

    private String getMD5(AbstractResourceMapper.CommonResource resource) {
        String str = resource.getSource();
        return this.getStringMD5(str);
    }

    private String getStringMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException("md5\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private String union(String str1, String str2, String ch) {
        if (str1 == null || str1.isEmpty()) {
            return str2;
        }
        if (str2 == null || str2.isEmpty()) {
            return str1;
        }
        return str1 + ch + str2;
    }
}

