/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mobile.controller;

import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.mobile.config.MobileConfig;
import com.af.v4.system.common.plugins.io.IOTools;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dir"})
public class MobileStaticResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileStaticResourceController.class);
    private final MobileConfig mobileConfig;

    public MobileStaticResourceController(MobileConfig mobileConfig) {
        this.mobileConfig = mobileConfig;
    }

    @Log(title="getFiles", businessType=BusinessType.OTHER)
    @PostMapping(value={"/getfile"}, produces={"application/json"})
    public String getFiles(@RequestBody String path) {
        StringBuilder result = new StringBuilder();
        if (path == null || path.trim().isEmpty()) {
            throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u4e3anull");
        }
        LOGGER.debug(path);
        File file = new File(path);
        List<File> files = this.list(file);
        for (File f : files) {
            if (!result.toString().isEmpty()) {
                result.append("|");
            }
            result.append(f.getPath()).append(",").append(f.lastModified());
        }
        LOGGER.debug(result.toString());
        return result.toString();
    }

    @Log(title="getGlobalFileByName", businessType=BusinessType.OTHER)
    @PostMapping(value={"/{name}"}, produces={"application/json"})
    public String getGlobalFileByName(@PathVariable String name, HttpServletResponse response) {
        try {
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            LOGGER.debug("{} path:{}", (Object)name, (Object)this.mobileConfig.getGlobalPath());
            try (FileInputStream is = new FileInputStream(this.mobileConfig.getGlobalPath());
                 BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                this.transformStream(is, os);
            }
        }
        catch (IOException e) {
            LOGGER.error("getGlobalFileByName\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return "";
    }

    @Log(title="getVersion", businessType=BusinessType.OTHER)
    @GetMapping(value={"/version"}, produces={"application/json"})
    public String getVersion(HttpServletResponse response) {
        String value = IOTools.readText((String)"app.json");
        try {
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            value = URLDecoder.decode(value, StandardCharsets.UTF_8);
            LOGGER.debug(value);
            try (FileInputStream is = new FileInputStream(value);
                 BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                this.transformStream(is, os);
            }
        }
        catch (IOException e) {
            LOGGER.error("getVersion\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return "";
    }

    @Log(title="getFile", businessType=BusinessType.OTHER)
    @PostMapping(produces={"application/json"})
    public String getFile(HttpServletResponse response, @RequestBody String fileName) {
        try {
            fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8);
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            LOGGER.debug(fileName);
            try (FileInputStream is = new FileInputStream(fileName);
                 BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                this.transformStream(is, os);
            }
        }
        catch (IOException e) {
            LOGGER.error("getFile\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return "";
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[1024];
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<File> list(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = dir.listFiles();
        assert (files != null);
        for (File file : files) {
            if (file.isDirectory()) {
                result.addAll(this.list(file));
                continue;
            }
            result.add(file);
        }
        return result;
    }
}

