/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.logic.service;

import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.gpt.service.PromptService;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.service.LiuLiConfigService;
import com.af.v4.system.common.logic.service.LogicNewTranService;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.resource.constant.CacheKey;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.common.resource.mapper.PluginMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LogicService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicService.class);
    private static final org.apache.logging.log4j.Logger LOG4J_LOGGER = LogManager.getLogger(LogicService.class);
    private final SqlService sqlService;
    private final LogicNewTranService logicNewTranService;
    private final RedisService redisService;
    private final RemoteLogicService remoteLogicService;
    private final EntityService entityService;
    private final PromptService promptService;
    private final LiuLiConfigService liuLiConfigService;
    private final LogicMapper logicMapper;
    private final ThreadPoolTaskExecutor taskExecutor;

    public LogicService(SqlService sqlService, LogicNewTranService newLogicService, RedisService redisService, RemoteLogicService remoteLogicService, EntityService entityService, PromptService promptService, LiuLiConfigService liuLiConfigService, LogicMapper logicMapper, @Qualifier(value="logicAsyncTaskExecutor") ThreadPoolTaskExecutor taskExecutor) {
        this.sqlService = sqlService;
        this.logicNewTranService = newLogicService;
        this.redisService = redisService;
        this.remoteLogicService = remoteLogicService;
        this.entityService = entityService;
        this.promptService = promptService;
        this.liuLiConfigService = liuLiConfigService;
        this.logicMapper = logicMapper;
        this.taskExecutor = taskExecutor;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public Object run(String logicName, JSONObject param, String dataSourceName) {
        LogicMapper.LogicResource resource = this.logicMapper.getValue(logicName);
        String name = resource.getAlias();
        boolean cache = resource.getCache();
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: \u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0cuseCache: " + cache + "\uff0cparams: " + param);
        if (cache) {
            String paramsStr = Optional.ofNullable(resource.getCacheKey()).orElse(new TreeMap(param.toMap()).toString());
            String cacheKey = CacheKey.getLogicDataCacheKey((String)logicName, (String)paramsStr);
            Object result = this.redisService.get(cacheKey);
            if (result != null) {
                LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: Logic[" + name + "]\u547d\u4e2d\u7f13\u5b58");
                return result;
            }
            AtomicReference returnResult = new AtomicReference();
            this.redisService.lock(cacheKey, Integer.valueOf(60), Integer.valueOf(300), () -> {
                Object newResult = this.redisService.get(cacheKey);
                if (newResult == null) {
                    long time;
                    newResult = this.action((LogicMapper.LogicResource<String>)resource, param, dataSourceName);
                    if (newResult instanceof JSONObject) {
                        JSONObject resultObj = (JSONObject)newResult;
                        time = resultObj.optLong("cacheTime", resource.getTime());
                    } else {
                        time = resource.getTime();
                    }
                    if (time > 0L) {
                        this.redisService.set(cacheKey, newResult, (Object)time);
                        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: Logic[" + name + "]\u7f13\u5b58\u6210\u529f\uff0c\u5b58\u6d3b\u65f6\u95f4\uff1a" + time + "\u79d2");
                    }
                } else {
                    LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: Logic[" + name + "]\u547d\u4e2d\u7f13\u5b58");
                }
                returnResult.set(newResult);
            });
            return returnResult.get();
        }
        return this.action((LogicMapper.LogicResource<String>)resource, param, dataSourceName);
    }

    public Object run(String name, JSONObject param) {
        return this.run(name, param, null);
    }

    public Object run(String name, String str) {
        return this.run(name, this.buildLogicParams(str));
    }

    public CompletableFuture<Object> runAsync(String name, JSONObject param) {
        return CompletableFuture.supplyAsync(() -> this.run(name, param), (Executor)this.taskExecutor).exceptionally(throwable -> {
            LOGGER.error("\u5f02\u6b65\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38.", throwable);
            return null;
        });
    }

    public CompletableFuture<Object> runAsync(String name, String str) {
        return this.runAsync(name, this.buildLogicParams(str));
    }

    public JSONObject remoteRun(String serviceName, String logicName, String params) {
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: \u5f00\u59cb\u8fdc\u7a0b\u8c03\u7528" + serviceName + "\u7684Logic[" + logicName + "]\uff0c\u53c2\u6570\uff1a" + params);
        return (JSONObject)this.logicMonitor(logicName, "\u8fdc\u7a0b\u8c03\u7528" + serviceName + ":" + logicName, params, () -> {
            R logicResult = this.remoteLogicService.run(serviceName, logicName, params, "inner");
            return logicResult.parseResponseJson();
        });
    }

    public JSONObject remoteRun(String serviceName, String logicName, JSONObject params) {
        return this.remoteRun(serviceName, logicName, params.toString());
    }

    private Object action(LogicMapper.LogicResource<String> resource, JSONObject param, String dataSourceName) {
        String name = resource.getAlias();
        String path = (String)resource.getPath();
        if (Optional.ofNullable(path).isEmpty()) {
            throw new ServiceException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name, Integer.valueOf(400));
        }
        String source = ResourceIndexer.getString((ResourceType)ResourceType.LOGIC, (String)name, (String)path);
        HashMap<String, Object> params = new HashMap<String, Object>(PluginMapper.pluginMap);
        params.put("data", param);
        params.put("log", LOG4J_LOGGER);
        params.put("entity", this.entityService);
        params.put("sql", this.sqlService);
        params.put("prompt", this.promptService);
        params.put("redis", this.redisService);
        params.put("logic", this);
        params.put("dataSource", new DynamicDataSource());
        params.put("liuLiConfig", this.liuLiConfigService);
        return this.logicMonitor(name, path, param.toString(), () -> {
            String dataSource = dataSourceName;
            if (Optional.ofNullable(dataSource).isEmpty()) {
                Map res = this.logicMapper.getRes(name);
                dataSource = (String)res.get("dataSource");
            }
            if (Optional.ofNullable(dataSource).isPresent()) {
                LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: Logic[" + name + "]\u4f7f\u7528\u6570\u636e\u6e90\uff1a" + dataSource);
                if (!Objects.equals(dataSource, DynamicDataSource.getDataSource())) {
                    DynamicDataSource.setDataSource((String)dataSource);
                }
                return this.logicNewTranService.runNewTranExpression(source, params);
            }
            DynamicDataSource.setDataSource(null);
            return this.runExpression(source, params);
        });
    }

    public Object runExpression(String source, Map<String, Object> params) {
        return Optional.ofNullable(Expression.run((String)source, params)).orElse("");
    }

    private ServiceException buildLogicException(String logicName, String logicPath, String logicParams, Exception ex) {
        ServiceException e;
        Object serviceException = ex instanceof ServiceException ? ((e = (ServiceException)ex).getCode() == null || e.getCode() == 500 ? new LogicException(ex, logicName, logicParams, logicPath) : e) : new LogicException(ex, logicName, logicParams, logicPath);
        return serviceException;
    }

    private JSONObject buildLogicParams(String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                JSONObject st = (JSONObject)json;
                param = st;
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                JSONArray ar = (JSONArray)json;
                param = new JSONObject();
                param.put("arr", (Object)ar);
            }
        }
        return param;
    }

    private Object logicMonitor(String name, String path, String params, Process process, Finally finallyFun) {
        long begin = System.currentTimeMillis();
        try {
            Object object = process.apply();
            return object;
        }
        catch (Exception e) {
            throw this.buildLogicException(name, path, params, e);
        }
        finally {
            if (finallyFun != null) {
                finallyFun.apply();
            }
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f: Logic[" + name + "]\u5904\u7406\u8017\u65f6:" + time;
            if (time >= 8000L) {
                LOGGER.error(engMessage);
            } else if (time >= 4000L) {
                LOGGER.warn(engMessage);
            } else {
                LOGGER.info(engMessage);
            }
        }
    }

    private Object logicMonitor(String name, String path, String params, Process process) {
        return this.logicMonitor(name, path, params, process, null);
    }

    @FunctionalInterface
    static interface Process {
        public Object apply();
    }

    @FunctionalInterface
    static interface Finally {
        public void apply();
    }
}

