/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.logic.service;

import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.logic.service.LogicNewTranService;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.common.resource.mapper.PluginMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LogicService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicService.class);
    private static final org.apache.logging.log4j.Logger LOG4J_LOGGER = LogManager.getLogger(LogicService.class);
    private final LogicNewTranService logicNewTranService;
    private final DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory;
    private final LogicMapper logicMapper;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final ApplicationUtils applicationUtils;

    public LogicService(LogicNewTranService newLogicService, DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory, LogicMapper logicMapper, @Qualifier(value="logicAsyncTaskExecutor") ThreadPoolTaskExecutor taskExecutor, ApplicationUtils applicationUtils) {
        this.logicNewTranService = newLogicService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.logicMapper = logicMapper;
        this.taskExecutor = taskExecutor;
        this.applicationUtils = applicationUtils;
    }

    private static String getDataSourceName(String dataSourceName, LogicMapper.LogicResource resource) {
        String mappingDataSource;
        String dataSource = dataSourceName == null ? ((mappingDataSource = resource.getDataSource()) != null ? mappingDataSource : DynamicDataSource.getDataSource()) : dataSourceName;
        return dataSource;
    }

    public static void setDataSource(String dataSourceName) {
        DynamicDataSource.setDataSource((String)dataSourceName);
    }

    public boolean has(String logicName) {
        return this.logicMapper.hasResource(logicName);
    }

    public Object run(String logicName, JSONObject param, String dataSourceName) {
        LogicMapper.LogicResource resource = (LogicMapper.LogicResource)this.logicMapper.getResource(logicName);
        String name = resource.getAlias();
        boolean cache = resource.isCache();
        String dataSource = LogicService.getDataSourceName(dataSourceName, resource);
        LOGGER.info("\u6267\u884cLogic[{}]\uff0cuseCache: {}\uff0cparams: {}\uff0cdataSource\uff1a{}", new Object[]{name, cache, param, dataSource});
        String source = resource.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>(PluginMapper.getPluginMap());
        params.put("data", param);
        params.put("log", LOG4J_LOGGER);
        params.put("ENV", this.applicationUtils.getValues());
        params.put("RESOURCE", resource.getJsonParams());
        params.put("logic", this);
        Supplier<Object> action = () -> {
            DynamicDataSource.setDataSource((String)dataSource);
            return this.logicMonitor(resource.getAlias(), resource.getPath().toString(), param.toString(), () -> this.runExpression(source, params));
        };
        if (dataSource.equals("master")) {
            return action.get();
        }
        try {
            return ((CompletableFuture)CompletableFuture.supplyAsync(action, (Executor)this.taskExecutor).exceptionally(throwable -> {
                Throwable cause = throwable.getCause();
                throw (ServiceException)cause;
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw (ServiceException)e.getCause();
        }
    }

    public Object run(String name, JSONObject param) {
        return this.run(name, param, null);
    }

    public Object run(String name, String str) {
        return this.run(name, this.buildLogicParams(str));
    }

    public CompletableFuture<Object> runAsync(String name, JSONObject param) {
        return CompletableFuture.supplyAsync(() -> this.run(name, param), (Executor)this.taskExecutor).exceptionally(throwable -> {
            LOGGER.error("\u5f02\u6b65\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38.", throwable);
            return null;
        });
    }

    public CompletableFuture<Object> runAsync(String name, String str) {
        return this.runAsync(name, this.buildLogicParams(str));
    }

    public JSONObject remoteRun(String serviceName, String logicName, String params) {
        LOGGER.info("\u8fdc\u7a0b\u8c03\u7528{}\u7684Logic[{}]\uff0c\u53c2\u6570\uff1a{}", new Object[]{serviceName, logicName, params});
        return (JSONObject)this.logicMonitor(logicName, "http://" + serviceName + "/logic/" + logicName, params, () -> {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, serviceName);
            R logicResult = remoteLogicService.run(logicName, params, "inner");
            return logicResult.parseResponseJson();
        });
    }

    public JSONObject remoteRun(String serviceName, String logicName, JSONObject params) {
        return this.remoteRun(serviceName, logicName, params.toString());
    }

    public Object runExpression(String source, Map<String, Object> params) {
        return Expression.run((String)source, params);
    }

    private ServiceException buildServiceException(String logicName, String logicPath, String logicParams, Exception ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)cause;
            cause = targetException.getTargetException();
        }
        if (cause instanceof LogicException) {
            LogicException logicException = (LogicException)cause;
            return new LogicException(logicException.getMessage(), logicException.getCode(), ex, logicName, logicParams, logicPath, logicException);
        }
        if (cause instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)cause;
            return new LogicException(serviceException.getMessage(), serviceException.getCode(), ex, logicName, logicParams, logicPath);
        }
        return new LogicException(ex, logicName, logicParams, logicPath);
    }

    private JSONObject buildLogicParams(String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                JSONObject st = (JSONObject)json;
                param = st;
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                JSONArray ar = (JSONArray)json;
                param = new JSONObject();
                param.put("arr", (Object)ar);
            }
        }
        return param;
    }

    private Object logicMonitor(String name, String path, String params, Process process, Finally finallyFun) {
        long begin = System.currentTimeMillis();
        try {
            Object object = process.apply();
            return object;
        }
        catch (Exception e) {
            throw this.buildServiceException(name, path, params, e);
        }
        finally {
            if (finallyFun != null) {
                finallyFun.apply();
            }
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "Logic[" + name + "]\u5904\u7406\u8017\u65f6:" + time + "ms";
            if (time >= 8000L) {
                LOGGER.error(engMessage);
            } else if (time >= 4000L) {
                LOGGER.warn(engMessage);
            } else {
                LOGGER.info(engMessage);
            }
        }
    }

    private Object logicMonitor(String name, String path, String params, Process process) {
        return this.logicMonitor(name, path, params, process, null);
    }

    @FunctionalInterface
    static interface Process {
        public Object apply();
    }

    @FunctionalInterface
    static interface Finally {
        public void apply();
    }
}

