/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.logic.service;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.gpt.service.PromptService;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.logic.service.ExceptionLogService;
import com.af.v4.system.common.logic.service.LogicNewTranService;
import com.af.v4.system.common.logic.utils.ExceptionHelper;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.resource.cache.CacheKey;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.common.resource.mapper.PluginMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LogicService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicService.class);
    private static final org.apache.logging.log4j.Logger LOG4J_LOGGER = LogManager.getLogger(LogicService.class);
    private final SqlService sqlService;
    private final LogicNewTranService logicNewTranService;
    private final RedisService redisService;
    private final RemoteLogicService remoteLogicService;
    private final RemoteEntityService remoteEntityService;
    private final EntityService entityService;
    private final PromptService promptService;
    private final LogicMapper logicMapper;
    @Qualifier(value="logicAsyncTaskExecutor")
    private final ThreadPoolTaskExecutor taskExecutor;

    public LogicService(SqlService sqlService, LogicNewTranService newLogicService, RedisService redisService, RemoteLogicService remoteLogicService, RemoteEntityService remoteEntityService, EntityService entityService, PromptService promptService, LogicMapper logicMapper, ThreadPoolTaskExecutor taskExecutor) {
        this.sqlService = sqlService;
        this.logicNewTranService = newLogicService;
        this.redisService = redisService;
        this.remoteLogicService = remoteLogicService;
        this.remoteEntityService = remoteEntityService;
        this.entityService = entityService;
        this.promptService = promptService;
        this.logicMapper = logicMapper;
        this.taskExecutor = taskExecutor;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public Object run(String logicName, JSONObject param, String dataSourceName) {
        LogicMapper.LogicResource resource = this.logicMapper.getValue(logicName);
        String name = resource.getAlias();
        boolean cache = resource.getCache();
        long time = resource.getTime();
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0ccacheInfo\uff1a[" + cache + "," + time + "]\uff0cparams\uff1a" + param);
        if (cache) {
            String paramsStr = new TreeMap(param.toMap()).toString();
            String cacheKey = CacheKey.getLogicDataCacheKey((String)logicName, (String)paramsStr);
            Object result = this.redisService.get(cacheKey);
            if (result != null) {
                LOGGER.debug("\u7ef4\u62a4\u4fe1\u606f:Logic[" + name + "]\u547d\u4e2d\u7f13\u5b58");
                return result;
            }
            AtomicReference returnResult = new AtomicReference();
            String cacheLockKey = CacheKey.getLogicDataCacheLockKey((String)logicName, (String)paramsStr);
            this.redisService.lock(cacheLockKey, Integer.valueOf(60), Integer.valueOf(300), () -> {
                Object newResult = this.redisService.get(cacheKey);
                if (newResult == null) {
                    newResult = this.action((LogicMapper.LogicResource<String>)resource, param, dataSourceName);
                    if (newResult != null && time > 0L) {
                        this.redisService.set(cacheKey, newResult, time);
                        LOGGER.debug("\u7ef4\u62a4\u4fe1\u606f:Logic[" + name + "]\u7f13\u5b58\u6210\u529f\uff0c\u5b58\u6d3b\u65f6\u95f4\uff1a" + time + "\u79d2");
                    }
                } else {
                    LOGGER.debug("\u7ef4\u62a4\u4fe1\u606f:Logic[" + name + "]\u547d\u4e2d\u7f13\u5b58");
                }
                returnResult.set(newResult);
            });
            return returnResult.get();
        }
        return this.action((LogicMapper.LogicResource<String>)resource, param, dataSourceName);
    }

    public Object run(String name, JSONObject param) {
        return this.run(name, param, null);
    }

    public Object run(String name, String str) {
        return this.run(name, this.buildLogicParams(str));
    }

    public CompletableFuture<Object> runAsync(String name, JSONObject param) {
        return CompletableFuture.supplyAsync(() -> this.run(name, param), (Executor)this.taskExecutor).exceptionally(throwable -> {
            Throwable patt6090$temp = throwable.getCause();
            if (patt6090$temp instanceof ServiceException) {
                ServiceException ex = (ServiceException)patt6090$temp;
                LOGGER.error("\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.\n {}", (Object)ex.getDetailMessage());
            } else {
                LOGGER.error("\u53d1\u751f\u5176\u4ed6\u5f02\u5e38.", throwable);
            }
            return null;
        });
    }

    public CompletableFuture<Object> runAsync(String name, String str) {
        return this.runAsync(name, this.buildLogicParams(str));
    }

    public JSONObject remoteRun(String serviceName, String logicName, String params) {
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u8fdc\u7a0b\u8c03\u7528" + serviceName + "\u7684Logic[" + logicName + "]\uff0c\u53c2\u6570\uff1a" + params);
        return (JSONObject)this.logicMonitor(logicName, () -> {
            R logicResult = this.remoteLogicService.run(serviceName, logicName, params, "inner");
            return logicResult.parseResponseJson();
        });
    }

    public JSONObject remoteRun(String serviceName, String logicName, JSONObject params) {
        return this.remoteRun(serviceName, logicName, params.toString());
    }

    private Object action(LogicMapper.LogicResource<String> resource, JSONObject param, String dataSourceName) {
        String name = resource.getAlias();
        String path = (String)resource.getPath();
        if (Optional.ofNullable(path).isEmpty()) {
            throw new ServiceException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        String source = ResourceIndexer.getString((ResourceType)ResourceType.LOGIC, (String)name, (String)path);
        HashMap<String, Object> params = new HashMap<String, Object>(PluginMapper.pluginMap);
        params.put("data", param);
        params.put("log", LOG4J_LOGGER);
        params.put("entity", this.entityService);
        params.put("remoteEntity", this.remoteEntityService);
        params.put("sql", this.sqlService);
        params.put("prompt", this.promptService);
        params.put("redis", this.redisService);
        params.put("logic", this);
        return this.logicMonitor(name, () -> {
            String dataSource = dataSourceName;
            if (Optional.ofNullable(dataSource).isEmpty()) {
                Map res = this.logicMapper.getRes(name);
                dataSource = (String)res.get("dataSource");
            }
            if (Optional.ofNullable(dataSource).isPresent()) {
                LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:Logic[" + name + "]\u4f7f\u7528\u6570\u636e\u6e90\uff1a" + dataSource);
                if (!Objects.equals(dataSource, DynamicDataSource.getDataSource())) {
                    DynamicDataSource.setDataSource((String)dataSource);
                }
                return this.logicNewTranService.runNewTranExpression(source, params);
            }
            DynamicDataSource.setDataSource(null);
            return this.runExpression(source, params);
        }, DynamicDataSource::clearDataSource);
    }

    public Object runExpression(String source, Map<String, Object> params) {
        Object runResult;
        try {
            runResult = Optional.ofNullable(Expression.run((String)source, params)).orElse("");
        }
        catch (Exception ex) {
            throw this.buildServiceException(ex);
        }
        return runResult;
    }

    private ServiceException buildServiceException(Exception ex) {
        ServiceException serviceException = null;
        if (ex instanceof ServiceException) {
            ServiceException e;
            serviceException = e = (ServiceException)ex;
        } else {
            InvocationTargetException targetException;
            Throwable throwable;
            Throwable cause = ex.getCause();
            if (cause instanceof InvocationTargetException && (throwable = (targetException = (InvocationTargetException)cause).getTargetException()) instanceof ServiceException) {
                ServiceException e;
                serviceException = e = (ServiceException)throwable;
            }
        }
        if (Optional.ofNullable(serviceException).isEmpty()) {
            serviceException = new ServiceException();
            String stack = ExceptionLogService.getErrorInfo(ExceptionHelper.stackToString(ex), ExceptionLogService.BusinessType.LOGIC);
            serviceException.setDetailMessage(stack);
            serviceException.setMessage("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            if (LogicService.isJUnitTest()) {
                LOGGER.error("\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.\n {}", (Object)stack);
            }
        }
        return serviceException;
    }

    private JSONObject buildLogicParams(String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                JSONObject st = (JSONObject)json;
                param = st;
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                JSONArray ar = (JSONArray)json;
                param = new JSONObject();
                param.put("arr", (Object)ar);
            }
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object logicMonitor(String name, Process process, Finally finallyFun) {
        long begin = System.currentTimeMillis();
        try {
            Object object = process.apply();
            return object;
        }
        finally {
            if (finallyFun != null) {
                finallyFun.apply();
            }
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f:Logic[" + name + "]\u5904\u7406\u8017\u65f6:" + time;
            if (time >= 8000L) {
                LOGGER.error(engMessage);
            } else if (time >= 4000L) {
                LOGGER.warn(engMessage);
            } else {
                LOGGER.info(engMessage);
            }
        }
    }

    private Object logicMonitor(String name, Process process) {
        return this.logicMonitor(name, process, null);
    }

    @FunctionalInterface
    static interface Process {
        public Object apply();
    }

    @FunctionalInterface
    static interface Finally {
        public void apply();
    }
}

