/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.log.nacos;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.log.nacos.Log4jInNacosConfig;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class Log4jInNacosConfigFactory
implements InstantiationAwareBeanPostProcessor {
    final String NODE_NAME;
    private final Log4jInNacosConfig log4JInNacosConfig;
    private final List<Appender> appenderList = new ArrayList<Appender>(3);
    private final AppenderRef[] appenderRefs = new AppenderRef[3];
    Configuration config;
    @Value(value="${spring.profiles.active}")
    private String envType;

    public Log4jInNacosConfigFactory(Log4jInNacosConfig log4JInNacosConfig) {
        this.log4JInNacosConfig = log4JInNacosConfig;
        this.NODE_NAME = System.getenv("NODE_NAME");
    }

    private void addLoggerConfig(Configuration config, String name, Level level) {
        AsyncLoggerConfig loggerConfig = (AsyncLoggerConfig)((AsyncLoggerConfig.Builder)((AsyncLoggerConfig.Builder)((AsyncLoggerConfig.Builder)((AsyncLoggerConfig.Builder)AsyncLoggerConfig.newAsyncBuilder().withLoggerName(name)).withLevel(level)).withConfig(config)).withRefs(this.appenderRefs)).build();
        config.addLogger(name, (LoggerConfig)loggerConfig);
    }

    public void createConfiguration() {
        String historyErrorLogPath;
        String errorLogPath;
        String historyLogPath;
        String logPath;
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        this.config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern(this.log4JInNacosConfig.getPattern()).build();
        EnvType envTypeEnum = EnvType.toType((String)this.envType);
        ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("Console")).setFilter((Filter)ThresholdFilter.createFilter((Level)Level.getLevel((String)this.log4JInNacosConfig.getConsoleLevel(envTypeEnum)), null, null))).setLayout((Layout)layout)).build();
        if (this.NODE_NAME != null) {
            logPath = this.log4JInNacosConfig.getLogFilePath() + "/" + this.NODE_NAME + "/log.log";
            historyLogPath = this.log4JInNacosConfig.getLogFilePath() + "/" + this.NODE_NAME + "/dailyLog/log_%d{yyyy-MM-dd_HH}.log";
            errorLogPath = this.log4JInNacosConfig.getLogFilePath() + "/" + this.NODE_NAME + "error.log";
            historyErrorLogPath = this.log4JInNacosConfig.getLogFilePath() + "/" + this.NODE_NAME + "/dailyError/error_%d{yyyy-MM-dd}.log";
        } else {
            logPath = this.log4JInNacosConfig.getLogFilePath() + "/log.log";
            historyLogPath = this.log4JInNacosConfig.getLogFilePath() + "/dailyLog/log_%d{yyyy-MM-dd_HH}.log";
            errorLogPath = this.log4JInNacosConfig.getLogFilePath() + "/error.log";
            historyErrorLogPath = this.log4JInNacosConfig.getLogFilePath() + "/dailyError/error_%d{yyyy-MM-dd}.log";
        }
        RollingRandomAccessFileAppender rollingFileInfoAppender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName("RollingFileInfo")).withFileName(logPath).setImmediateFlush(false)).withFilePattern(historyLogPath).setFilter((Filter)ThresholdFilter.createFilter((Level)Level.DEBUG, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY))).setLayout((Layout)layout)).withPolicy((TriggeringPolicy)TimeBasedTriggeringPolicy.newBuilder().withInterval(1).withModulate(true).build()).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax(this.log4JInNacosConfig.getMaxFileNum()).build()).build();
        RollingRandomAccessFileAppender rollingFileErrorAppender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName("RollingFileError")).withFileName(errorLogPath).setImmediateFlush(false)).withFilePattern(historyErrorLogPath).setFilter((Filter)ThresholdFilter.createFilter((Level)Level.WARN, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY))).setLayout((Layout)layout)).withPolicy((TriggeringPolicy)TimeBasedTriggeringPolicy.newBuilder().withInterval(1).withModulate(true).build()).build();
        this.appenderList.add((Appender)consoleAppender);
        this.appenderList.add((Appender)rollingFileInfoAppender);
        this.appenderList.add((Appender)rollingFileErrorAppender);
        LoggerConfig rootConfig = this.config.getRootLogger();
        rootConfig.removeAppender(consoleAppender.getName());
        rootConfig.setLevel(Level.WARN);
        for (int i = 0; i < this.appenderList.size(); ++i) {
            Appender appender = this.appenderList.get(i);
            appender.start();
            this.appenderRefs[i] = AppenderRef.createAppenderRef((String)appender.getName(), null, null);
            rootConfig.addAppender(appender, null, null);
        }
        this.addLoggerConfig(this.config, "com.af", envTypeEnum == EnvType.PROD ? Level.INFO : Level.DEBUG);
        this.addLoggerConfig(this.config, "org.springframework", Level.ERROR);
        this.addLoggerConfig(this.config, "com.microsoft.sqlserver", Level.ERROR);
        this.addLoggerConfig(this.config, "com.clickhouse", Level.ERROR);
        this.addLoggerConfig(this.config, "org.hibernate", Level.ERROR);
        context.updateLoggers();
    }

    public Object postProcessBeforeInstantiation(@Nonnull Class<?> beanClass, String beanName) throws BeansException {
        if (beanName.equals("tomcatServletWebServerFactory") || beanName.equals("nettyReactiveWebServerFactory")) {
            this.createConfiguration();
        }
        return super.postProcessBeforeInstantiation(beanClass, beanName);
    }
}

