/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.log.nacos;

import com.af.v4.system.common.core.enums.EnvType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="log4j")
@Component
public class Log4jInNacosConfig {
    private String APPLICATION_NAME;
    private String logFilePath;
    private String pattern;
    private String maxFileNum;
    private String consoleLevel;

    @Value(value="${spring.application.name}")
    public void setApplicationName(String applicationName) {
        this.APPLICATION_NAME = applicationName;
    }

    public String getLogFilePath() {
        if (this.logFilePath == null) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("linux")) {
                return "/application/afServer/afLogs/" + this.APPLICATION_NAME;
            }
            return "D:/afServer/afLogs/" + this.APPLICATION_NAME;
        }
        return this.logFilePath + "/" + this.APPLICATION_NAME;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getPattern() {
        if (this.pattern == null) {
            return "%d [%p] - [%l] - %t - %m%n";
        }
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getMaxFileNum() {
        if (this.maxFileNum == null) {
            return "2000";
        }
        return this.maxFileNum;
    }

    public void setMaxFileNum(String maxFileNum) {
        this.maxFileNum = maxFileNum;
    }

    public String getConsoleLevel(EnvType envType) {
        if (this.consoleLevel == null) {
            if (envType != EnvType.PROD) {
                return "DEBUG";
            }
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("linux")) {
                return "INFO";
            }
            return "OFF";
        }
        return this.consoleLevel;
    }

    public void setConsoleLevel(String consoleLevel) {
        this.consoleLevel = consoleLevel;
    }
}

