package com.af.v4.system.common.log.nacos;

import com.af.v4.system.common.core.enums.EnvType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;


/**
 * Log4j2 in Nacos 配置
 *
 * @author 朱子峰
 */
@Configuration
@ConfigurationProperties(prefix = "log4j")
@Component
public class Log4jInNacosConfig {
    private String APPLICATION_NAME;
    private String logFilePath;
    private String pattern;
    private String maxFileNum;
    private String consoleLevel;

    @Value("${spring.application.name}")
    public void setApplicationName(String applicationName) {
        APPLICATION_NAME = applicationName;
    }

    public String getLogFilePath() {
        if (logFilePath == null) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("linux")) {
                return "/application/afServer/afLogs/" + APPLICATION_NAME;
            } else {
                return "D:/afServer/afLogs/" + APPLICATION_NAME;
            }
        } else {
            return logFilePath + "/" + APPLICATION_NAME;
        }
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getPattern() {
        if (pattern == null) {
            return "%d [%p] - [%l] - %t - %m%n";
        }
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getMaxFileNum() {
        if (maxFileNum == null) {
            return "2000";
        }
        return maxFileNum;
    }

    public void setMaxFileNum(String maxFileNum) {
        this.maxFileNum = maxFileNum;
    }

    public String getConsoleLevel(EnvType envType) {
        if (consoleLevel == null) {
            if (envType != EnvType.PROD) {
                return "DEBUG";
            } else {
                String osName = System.getProperty("os.name").toLowerCase();
                if (osName.contains("linux")) {
                    return "INFO";
                } else {
                    return "OFF";
                }
            }
        }
        return consoleLevel;
    }

    public void setConsoleLevel(String consoleLevel) {
        this.consoleLevel = consoleLevel;
    }
}
