package com.af.v4.system.common.log.service;

import com.af.v4.system.api.RemoteLogService;
import com.af.v4.system.common.core.constant.SecurityConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * 异步调用日志服务
 */
@Service
public class AsyncLogService {

    private static final Logger log = LoggerFactory.getLogger(AsyncLogService.class);

    private final RemoteLogService remoteLogService;

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    public AsyncLogService(RemoteLogService remoteLogService) {
        this.remoteLogService = remoteLogService;
    }

    /**
     * 保存系统日志记录
     */
    @Async
    public void saveSysLog(String sysOperLog) {
        try {
            remoteLogService.saveLog(sysOperLog, SecurityConstants.INNER);
        } catch (LinkageError e) {
            log.error("保存系统日志记录失败，请检查网关服务是否正常启动");
        }
    }
}
