/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.log.aspect;

import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.ip.IpUtils;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessStatus;
import com.af.v4.system.common.log.filter.PropertyPreExcludeFilter;
import com.af.v4.system.common.log.service.AsyncLogService;
import com.af.v4.system.common.security.utils.SecurityUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAspect {
    public static final String[] EXCLUDE_PROPERTIES = new String[]{"password", "oldPassword", "newPassword", "confirmPassword"};
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private static final ThreadLocal<Long> TIME_THREADLOCAL = new NamedThreadLocal("Cost Time");
    private final AsyncLogService asyncLogService;

    public LogAspect(AsyncLogService asyncLogService) {
        this.asyncLogService = asyncLogService;
    }

    @Before(value="@annotation(controllerLog)")
    public void boBefore(JoinPoint joinPoint, Log controllerLog) {
        TIME_THREADLOCAL.set(System.currentTimeMillis());
    }

    @AfterReturning(pointcut="@annotation(controllerLog)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Log controllerLog, Object jsonResult) {
        this.handleLog(joinPoint, controllerLog, null, jsonResult);
    }

    @AfterThrowing(value="@annotation(controllerLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Log controllerLog, Exception e) {
        this.handleLog(joinPoint, controllerLog, e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLog(JoinPoint joinPoint, Log controllerLog, Exception e, Object jsonResult) {
        try {
            JSONObject operLog = new JSONObject();
            operLog.put("f_status", BusinessStatus.SUCCESS.ordinal());
            String ip = IpUtils.getIpAddr();
            operLog.put("f_oper_ip", (Object)ip);
            operLog.put("f_oper_url", (Object)StringUtils.substring((String)ServletUtils.getRequest().getRequestURI(), (int)0, (int)255));
            String username = SecurityUtils.getUsername();
            if (StringUtils.isNotBlank((CharSequence)username)) {
                operLog.put("f_oper_name", (Object)username);
            }
            if (e != null) {
                operLog.put("f_status", BusinessStatus.FAIL.ordinal());
                operLog.put("f_error_msg", (Object)StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            operLog.put("f_method", (Object)(className + "." + methodName + "()"));
            operLog.put("f_request_method", (Object)ServletUtils.getRequest().getMethod());
            this.getControllerMethodDescription(joinPoint, controllerLog, operLog, jsonResult);
            operLog.put("f_cost_time", System.currentTimeMillis() - TIME_THREADLOCAL.get());
            this.asyncLogService.saveSysLog(operLog.toString());
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
        finally {
            TIME_THREADLOCAL.remove();
        }
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, Log log, JSONObject operLog, Object jsonResult) {
        operLog.put("f_business_type", log.businessType().ordinal());
        operLog.put("f_title", (Object)log.title());
        operLog.put("f_operator_type", log.operatorType().ordinal());
        if (log.isSaveRequestData()) {
            this.setRequestValue(joinPoint, operLog, log.excludeParamNames());
        }
        if (log.isSaveResponseData() && StringUtils.isNotNull((Object)jsonResult)) {
            operLog.put("f_json_result", (Object)StringUtils.substring((String)new JSONObject(jsonResult).toString(), (int)0, (int)2000));
        }
    }

    private void setRequestValue(JoinPoint joinPoint, JSONObject operLog, String[] excludeParamNames) {
        String requestMethod = operLog.getString("f_request_method");
        Map paramsMap = ServletUtils.getParamMap((ServletRequest)ServletUtils.getRequest());
        if (StringUtils.isEmpty((Map)paramsMap) && (HttpMethod.PUT.name().equals(requestMethod) || HttpMethod.POST.name().equals(requestMethod))) {
            String params = this.argsArrayToString(joinPoint.getArgs(), excludeParamNames);
            operLog.put("f_oper_param", (Object)StringUtils.substring((String)params, (int)0, (int)2000));
        } else {
            operLog.put("f_oper_param", (Object)StringUtils.substring((String)JSON.toJSONString((Object)paramsMap, (Filter)this.excludePropertyPreFilter(excludeParamNames), (JSONWriter.Feature[])new JSONWriter.Feature[0]), (int)0, (int)2000));
        }
    }

    private String argsArrayToString(Object[] paramsArray, String[] excludeParamNames) {
        StringBuilder params = new StringBuilder();
        if (paramsArray != null) {
            for (Object o : paramsArray) {
                if (!StringUtils.isNotNull((Object)o) || this.isFilterObject(o)) continue;
                try {
                    String jsonObj = JSON.toJSONString((Object)o, (Filter)this.excludePropertyPreFilter(excludeParamNames), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
                    params.append(jsonObj).append(" ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return params.toString().trim();
    }

    public PropertyPreExcludeFilter excludePropertyPreFilter(String[] excludeParamNames) {
        return new PropertyPreExcludeFilter().addExcludes((String[])ArrayUtils.addAll((Object[])EXCLUDE_PROPERTIES, (Object[])excludeParamNames));
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

