/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.utils;

import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Tuple;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.liuli.utils.enums.JoinTypeEnum;
import com.af.v4.system.common.liuli.utils.enums.QueryTypeEnum;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLParserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLParserUtil.class);
    private static final String DEFAULT_ALL_VALUE = "\u5168\u90e8";
    private static final String DEFAULT_NULL_VALUE = "NULL";
    private static final String MOBILE_FIXED_QUERY_KEY = "$queryValue";

    public static JSONObject getSingleStyleQuerySQL(JSONObject queryParamsMap, JSONObject params, String sortField, String sortOrder) {
        JSONObject querySQlMap = SQLParserUtil.getQuerySQL(queryParamsMap, params, sortField, sortOrder);
        String querySql = querySQlMap.getString("querySql");
        String countSql = querySQlMap.getString("countSql");
        JSONObject result = new JSONObject();
        result.put("items", (Object)SQLParserUtil.extractSqlPart(querySql, "SELECT", "FROM"));
        result.put("tableName", (Object)SQLParserUtil.extractSqlPart(querySql, "FROM", "WHERE"));
        result.put("condition", (Object)querySql.substring(querySql.indexOf("WHERE") + "WHERE".length()).trim());
        result.put("countItems", (Object)SQLParserUtil.extractSqlPart(countSql, "SELECT", "FROM"));
        result.put("countTableName", (Object)SQLParserUtil.extractSqlPart(countSql, "FROM", "WHERE"));
        result.put("countCondition", (Object)countSql.substring(countSql.indexOf("WHERE") + "WHERE".length()).trim());
        result.put("querySql", (Object)querySql);
        result.put("countSql", (Object)countSql);
        return result;
    }

    public static JSONObject getQuerySQL(JSONObject queryParamsMap, JSONObject params, String sortField, String sortOrder) {
        StringBuilder querySql = new StringBuilder(queryParamsMap.getString("querySql"));
        StringBuilder countSql = new StringBuilder(queryParamsMap.getString("countSql"));
        StringBuilder tableSummarySql = new StringBuilder(queryParamsMap.optString("tableSummarySql"));
        SQLParserUtil.appendWhereAndJoinCondition(querySql, countSql, tableSummarySql, queryParamsMap, params);
        SQLParserUtil.appendOrderBy(querySql, queryParamsMap, sortField, sortOrder);
        queryParamsMap.optJSONArray("tabNameSuffix", new JSONArray()).forEach(item -> {
            JSONObject tabNameSuffix = (JSONObject)item;
            String tabName = tabNameSuffix.getString("tableName").split(" ")[0];
            String suffixModel = tabNameSuffix.getString("column");
            if (querySql.indexOf(tabName) != -1 && params.has(suffixModel)) {
                SQLParserUtil.replaceInStringBuilder(querySql, tabName, tabName + String.valueOf(params.get(suffixModel)));
                SQLParserUtil.replaceInStringBuilder(countSql, tabName, tabName + String.valueOf(params.get(suffixModel)));
                SQLParserUtil.replaceInStringBuilder(tableSummarySql, tabName, tabName + String.valueOf(params.get(suffixModel)));
            }
        });
        JSONObject result = new JSONObject();
        result.put("querySql", (Object)querySql.toString());
        result.put("countSql", (Object)countSql.toString());
        result.put("tableSummarySql", (Object)tableSummarySql.toString());
        return result;
    }

    public static void putJoinCondition(String joinTableAlias, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray, Boolean useJoinByCount) {
        boolean isContains;
        if (joinTableAlias.equals(tableAliasName) || joinTableAlias.equals("$")) {
            return;
        }
        if (!joinTableNameObject.has(joinTableAlias)) {
            throw new ServiceException("\u5728\u7ec4\u7ec7JOIN\u8868\u8fbe\u5f0f\u65f6\uff0c\u6ca1\u6709\u627e\u5230\u5173\u4e8e\u8868\u522b\u540d[" + joinTableAlias + "]\u7684JOIN\u8868\u8fbe\u5f0f\u914d\u7f6e\u4fe1\u606f", Integer.valueOf(400));
        }
        boolean bl = isContains = SQLParserUtil.getCanJoinTableItem(canJoinTableNameArray, joinTableAlias) != null;
        if (!isContains) {
            SQLParserUtil.addNewJoinCondition(canJoinTableNameArray, joinTableNameObject, joinTableAlias, tableAliasName, useJoinByCount);
        } else {
            SQLParserUtil.updateJoinCondition(canJoinTableNameArray, joinTableNameObject, joinTableAlias, tableAliasName, useJoinByCount);
        }
    }

    private static void addNewJoinCondition(JSONArray canJoinTableNameArray, JSONObject joinTableNameObject, String joinTableAlias, String tableAliasName, boolean useJoinByCount) {
        JSONObject joinObj = joinTableNameObject.getJSONObject(joinTableAlias);
        String joinType = joinObj.getString("type");
        String joinCondition = joinObj.getString("value");
        JSONObject params = new JSONObject();
        params.put("type", (Object)joinType);
        params.put("alias", (Object)joinTableAlias);
        params.put("useJoinByCount", useJoinByCount);
        if (joinType.equals("join")) {
            String shouldJoinTableAlias = SQLParserUtil.getShouldJoinTableAlias(joinTableAlias, tableAliasName, joinCondition = joinCondition.toLowerCase());
            if (shouldJoinTableAlias != null) {
                SQLParserUtil.putJoinCondition(shouldJoinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, useJoinByCount);
            }
            params.put("value", (Object)(JoinTypeEnum.LEFT_OUT_JOIN.getValue() + " " + joinCondition));
        } else {
            params.put("value", (Object)joinCondition);
        }
        canJoinTableNameArray.put((Object)params);
    }

    private static void updateJoinCondition(JSONArray canJoinTableNameArray, JSONObject joinTableNameObject, String joinTableAlias, String tableAliasName, boolean useJoinByCount) {
        JSONObject params = SQLParserUtil.getCanJoinTableItem(canJoinTableNameArray, joinTableAlias);
        assert (params != null);
        params.put("useJoinByCount", useJoinByCount);
        if (!useJoinByCount) {
            return;
        }
        JSONObject joinObj = joinTableNameObject.getJSONObject(joinTableAlias);
        String joinType = joinObj.getString("type");
        if (!joinType.equals("join")) {
            return;
        }
        String joinCondition = joinObj.getString("value").toLowerCase();
        String shouldJoinTableAlias = SQLParserUtil.getShouldJoinTableAlias(joinTableAlias, tableAliasName, joinCondition);
        if (shouldJoinTableAlias == null) {
            return;
        }
        params = SQLParserUtil.getCanJoinTableItem(canJoinTableNameArray, shouldJoinTableAlias);
        assert (params != null);
        params.put("useJoinByCount", true);
        SQLParserUtil.putJoinCondition(shouldJoinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, true);
    }

    private static JSONObject getCanJoinTableItem(JSONArray canJoinTableNameArray, String alias) {
        for (Object itemObject : canJoinTableNameArray) {
            JSONObject item = (JSONObject)itemObject;
            if (!item.getString("alias").equals(alias)) continue;
            return item;
        }
        return null;
    }

    private static String getShouldJoinTableAlias(String joinTableAlias, String tableAliasName, String joinCondition) {
        String onCondition = joinCondition.substring(joinCondition.indexOf(" on ") + 4);
        int firstAliasIndex = onCondition.indexOf(".");
        String firstAlias = onCondition.substring(0, firstAliasIndex);
        String conditionPart = onCondition.substring(firstAliasIndex + 1);
        String secondAlias = conditionPart.substring(conditionPart.indexOf("=") + 1, conditionPart.indexOf(".")).trim();
        if (firstAlias.equals(tableAliasName) || secondAlias.equals(tableAliasName)) {
            return null;
        }
        return firstAlias.equals(joinTableAlias) ? secondAlias : firstAlias;
    }

    private static void appendConditionByType(StringBuilder condition, JSONObject queryParams, String key, String realKey, String value, DbType dbType) {
        String queryTypeStr = queryParams.getString("queryType");
        if (!QueryTypeEnum.is(queryTypeStr) && !key.equals(MOBILE_FIXED_QUERY_KEY)) {
            throw new ServiceException("\u8868\u5355\u5b57\u6bb5[" + key + "]\u65e0\u6cd5\u751f\u6210\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u4e3a\u914d\u7f6e\u7684\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + queryTypeStr, Integer.valueOf(400));
        }
        QueryTypeEnum queryType = key.equals(MOBILE_FIXED_QUERY_KEY) ? QueryTypeEnum.INNER_LIKE : QueryTypeEnum.toType(queryTypeStr);
        switch (queryType) {
            case EQUALS: 
            case NO_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUALS: {
                String mark = queryType.getValue();
                if (DEFAULT_NULL_VALUE.equalsIgnoreCase(value)) {
                    condition.append("\n\tAND ").append(realKey).append(" IS NULL");
                    break;
                }
                condition.append("\n\tAND ").append(realKey).append(" ").append(mark).append(" '").append(value).append("'");
                break;
            }
            case INNER_LIKE: {
                if (condition.indexOf("AND") != -1 && key.equals(MOBILE_FIXED_QUERY_KEY)) {
                    condition.append("\n\tOR ").append(realKey).append(" LIKE '%").append(value).append("%'");
                    break;
                }
                condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("%'");
                break;
            }
            case LEFT_LIKE: {
                condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("'");
                break;
            }
            case RIGHT_LIKE: {
                condition.append("\n\tAND ").append(realKey).append(" LIKE '").append(value).append("%'");
                break;
            }
            case IN: {
                String[] values;
                int length;
                if (value.startsWith("[") && value.endsWith("]")) {
                    value = CommonTools.union((JSONArray)JsonTools.parseArray((String)value));
                }
                if ((length = (values = value.split(",")).length) > 1000) {
                    condition.append("\n\tAND (");
                    for (int i = 0; i < length; i += 1000) {
                        if (i > 0) {
                            condition.append("\n\tOR ");
                        }
                        String subCondition = String.join((CharSequence)", ", Arrays.copyOfRange(values, i, Math.min(i + 1000, length)));
                        condition.append(realKey).append(" IN (").append(subCondition).append(")");
                    }
                    condition.append("\n\t)");
                    break;
                }
                condition.append("\n\tAND ").append(realKey).append(" IN (").append(value).append(")");
                break;
            }
            case NOT_IN: {
                if (value.startsWith("[") && value.endsWith("]")) {
                    value = CommonTools.union((JSONArray)JsonTools.parseArray((String)value));
                }
                condition.append("\n\tAND ").append(realKey).append(" NOT IN (").append(value).append(")");
                break;
            }
            case BETWEEN: {
                JSONArray array = new JSONArray(value);
                Object beginValue = array.get(0).toString();
                Object endValue = array.get(1).toString();
                if (!((String)beginValue).isEmpty() && !((String)endValue).isEmpty()) {
                    try {
                        beginValue = DateUtil.parse((CharSequence)beginValue).toString();
                        endValue = DateUtil.parse((CharSequence)endValue).toString();
                        if (DbType.oracle == dbType) {
                            if (((String)beginValue).length() <= 10) {
                                beginValue = "TO_DATE('" + (String)beginValue + "', 'yyyy-MM-dd')";
                                endValue = "TO_DATE('" + (String)endValue + "', 'yyyy-MM-dd')";
                            } else {
                                beginValue = "TO_DATE('" + (String)beginValue + "', 'yyyy-MM-dd HH24:mi:ss')";
                                endValue = "TO_DATE('" + (String)endValue + "', 'yyyy-MM-dd HH24:mi:ss')";
                            }
                        } else {
                            beginValue = "'" + (String)beginValue + "'";
                            endValue = "'" + (String)endValue + "'";
                        }
                    }
                    catch (DateException e) {
                        beginValue = "'" + (String)beginValue + "'";
                        endValue = "'" + (String)endValue + "'";
                    }
                    condition.append("\n\tAND ").append(realKey).append(" BETWEEN ").append((String)beginValue).append(" AND ").append((String)endValue);
                    break;
                }
                if (!((String)beginValue).isEmpty()) {
                    condition.append("\n\tAND ").append(realKey).append(" >= ").append((String)beginValue);
                    break;
                }
                if (((String)endValue).isEmpty()) break;
                condition.append("\n\tAND ").append(realKey).append(" <= ").append((String)endValue);
                break;
            }
            default: {
                throw new ServiceException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b\uff1a" + queryType.getValue(), Integer.valueOf(400));
            }
        }
    }

    private static void appendWhereAndJoinCondition(StringBuilder querySql, StringBuilder tableSummarySql, StringBuilder countSql, JSONObject queryParamsMap, JSONObject params) {
        JSONObject joinTableNameObject = queryParamsMap.getJSONObject("joinTableNameObject");
        JSONArray canJoinTableNameArray = queryParamsMap.getJSONArray("canJoinTableNameArray");
        String tableAliasName = queryParamsMap.getString("tableAliasName");
        String conditionStr = queryParamsMap.getString("condition");
        boolean isCheck = queryParamsMap.has("queryBeforeAggSql");
        String whereConditionStr = SQLParserUtil.getConditionValue(queryParamsMap.getJSONObject("selectColumn"), params, tableAliasName, joinTableNameObject, canJoinTableNameArray, conditionStr, isCheck);
        canJoinTableNameArray.forEach(item -> {
            JSONObject joinObject = (JSONObject)item;
            String condition = joinObject.getString("value");
            querySql.append("\n\t").append(condition);
            if (joinObject.getBoolean("useJoinByCount")) {
                countSql.append("\n\t").append(condition);
                tableSummarySql.append("\n\t").append(condition);
            }
        });
        querySql.append("\nWHERE ").append(whereConditionStr);
        countSql.append("\nWHERE ").append(whereConditionStr);
        tableSummarySql.append("\nWHERE ").append(whereConditionStr);
    }

    private static void appendOrderBy(StringBuilder querySql, JSONObject queryParamsMap, String sortField, String sortOrder) {
        String orderBy;
        if (sortField == null) {
            orderBy = queryParamsMap.getString("orderBy");
        } else {
            JSONObject queryParams = queryParamsMap.getJSONObject("selectColumn").getJSONObject(sortField);
            Tuple tuple = SQLParserUtil.getRealKeyAndTableAlias(queryParams, sortField);
            String realKey = (String)tuple.get(0);
            orderBy = Optional.ofNullable(sortOrder).filter("descend"::equals).map(o -> realKey + " DESC").orElse(realKey);
        }
        querySql.append("\nORDER BY ").append(orderBy);
    }

    public static String getConditionValue(JSONObject queryMap, JSONObject params, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray, String conditionStr) {
        return SQLParserUtil.getConditionValue(queryMap, params, tableAliasName, joinTableNameObject, canJoinTableNameArray, conditionStr, false);
    }

    private static String getConditionValue(JSONObject selectColumn, JSONObject params, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray, String conditionStr, boolean skipCheck) {
        DbType dbType = DynamicDataSource.getDbType();
        StringBuilder condition = new StringBuilder(conditionStr);
        Iterator iterator = params.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = String.valueOf(params.get(key));
            if (conditionStr.contains("{" + key + "}")) {
                SQLParserUtil.replaceInStringBuilder(condition, "{" + key + "}", value);
                continue;
            }
            if (value.isEmpty() || DEFAULT_ALL_VALUE.equals(value)) continue;
            if (!selectColumn.has(key) && !key.equals(MOBILE_FIXED_QUERY_KEY)) {
                if (skipCheck) continue;
                LOGGER.warn("\u8868\u5355\u5b57\u6bb5[{}]\u65e0\u6cd5\u751f\u6210\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u8fd9\u4e2a\u5b57\u6bb5\u7684\u76f8\u5173\u4fe1\u606f", (Object)key);
                continue;
            }
            if (key.equals(MOBILE_FIXED_QUERY_KEY)) {
                for (String queryKey : selectColumn.keySet()) {
                    JSONObject queryParams = selectColumn.getJSONObject(queryKey);
                    QueryTypeEnum queryTypeEnum = QueryTypeEnum.toType(queryParams.get("queryType").toString());
                    if (queryTypeEnum != QueryTypeEnum.EQUALS && queryTypeEnum != QueryTypeEnum.LEFT_LIKE && queryTypeEnum != QueryTypeEnum.RIGHT_LIKE && queryTypeEnum != QueryTypeEnum.INNER_LIKE) continue;
                    Tuple tuple = SQLParserUtil.getRealKeyAndTableAlias(queryParams, key);
                    SQLParserUtil.appendConditionByType(condition, queryParams, key, (String)tuple.get(0), value, dbType);
                    SQLParserUtil.putJoinCondition((String)tuple.get(1), tableAliasName, joinTableNameObject, canJoinTableNameArray, true);
                }
                continue;
            }
            JSONObject queryParams = selectColumn.getJSONObject(key);
            Tuple tuple = SQLParserUtil.getRealKeyAndTableAlias(queryParams, key);
            SQLParserUtil.appendConditionByType(condition, queryParams, key, (String)tuple.get(0), value, dbType);
            SQLParserUtil.putJoinCondition((String)tuple.get(1), tableAliasName, joinTableNameObject, canJoinTableNameArray, true);
        }
        return condition.toString();
    }

    private static Tuple getRealKeyAndTableAlias(JSONObject queryParams, String key) {
        String realKey;
        String tableAlias;
        if (key.indexOf(46) == -1 || key.startsWith("$_")) {
            key = key.replaceFirst("_", ".");
        }
        if ((tableAlias = (realKey = queryParams.getString("key")).substring(0, realKey.indexOf(46))).equals("$")) {
            String[] spiltKeyArray = key.split(" ");
            realKey = spiltKeyArray[0].substring(2);
        }
        return new Tuple(new Object[]{realKey, tableAlias});
    }

    private static String extractSqlPart(String sql, String startKeyword, String endKeyword) {
        int startIndex = sql.indexOf(startKeyword) + startKeyword.length();
        int endIndex = sql.indexOf(endKeyword, startIndex);
        return sql.substring(startIndex, endIndex).trim();
    }

    public static String replaceQueryItem(JSONArray fields, String sql) {
        String originalField = SQLParserUtil.extractSqlPart(sql, "SELECT", "FROM").trim();
        if (originalField.isEmpty()) {
            LOGGER.warn("\u53d1\u73b0\u6307\u5b9a\u67e5\u8be2\u5b57\u6bb5\uff0c\u4f46\u662f\u83b7\u53d6\u539f\u59cbsql\u67e5\u8be2\u5b57\u6bb5\u9519\u8bef\uff0c\u8fd4\u56de\u539fSQL");
            return sql;
        }
        List<String> targetFields = fields.toList().stream().map(Object::toString).toList();
        Map<String, String> aliasToFieldMap = Arrays.stream(originalField.split(",\n")).map(String::trim).collect(Collectors.toMap(item -> {
            String[] parts = item.split(" ");
            return parts[parts.length - 1].replace("\"", "");
        }, item -> item, (a, b) -> a));
        List<String> filteredFields = targetFields.stream().filter(aliasToFieldMap::containsKey).map(aliasToFieldMap::get).toList();
        if (filteredFields.isEmpty()) {
            LOGGER.warn("\u53d1\u73b0\u6307\u5b9a\u67e5\u8be2\u5b57\u6bb5\uff0c\u4f46\u662f\u672a\u5728\u539f\u59cbsql\u7b5b\u9009\u51fa\u5b57\u6bb5\uff0c\u8fd4\u56de\u539fSQL");
            return sql;
        }
        String newField = String.join((CharSequence)",\n ", filteredFields);
        return sql.replace(originalField, newField);
    }

    private static void replaceInStringBuilder(StringBuilder sb, String oldStr, String newStr) {
        int index = sb.indexOf(oldStr);
        while (index != -1) {
            sb.replace(index, index + oldStr.length(), newStr);
            index = sb.indexOf(oldStr, index + newStr.length());
        }
    }

    public static String findDeepestTableName(String sql) {
        Pattern fromPattern = Pattern.compile("FROM\\s+(\\w+)", 2);
        Matcher fromMatcher = fromPattern.matcher(sql);
        String result = null;
        if (fromMatcher.find()) {
            result = fromMatcher.group(1);
        }
        return result;
    }

    public static List<JSONObject> getChildTableItems(JSONArray formJson, JSONObject formData) {
        ArrayList<JSONObject> childTableFormItems = new ArrayList<JSONObject>(1);
        formJson.forEach(item -> {
            JSONObject formItem = (JSONObject)item;
            if (formItem.getString("type").equals("childTable")) {
                childTableFormItems.add(formItem);
            }
        });
        if (childTableFormItems.isEmpty()) {
            return childTableFormItems;
        }
        return childTableFormItems.stream().filter(item -> {
            String modal = item.getString("model");
            return formData.has(modal);
        }).toList();
    }
}

