/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.subscriber;

import cn.hutool.cache.impl.LRUCache;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.redis.RedisService;
import java.util.List;
import org.json.JSONObject;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class LiuLiCacheSubscriber
implements ApplicationRunner {
    public static final String CLEAR_CACHE_TOPIC_NAME = "Topic_LiuLi_ClearCache";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiCacheSubscriber.class);
    private final RedisService redisService;

    public LiuLiCacheSubscriber(RedisService redisService) {
        this.redisService = redisService;
    }

    public void run(ApplicationArguments args) {
        RTopic topic = this.redisService.getTopic(CLEAR_CACHE_TOPIC_NAME);
        topic.addListener(JSONObject.class, (charSequence, object) -> {
            String namespaceName = object.getString("namespaceName");
            String environment = object.getString("environment");
            String configName = object.getString("configName");
            String configCacheKey = LiuLiConfigService.getConfigCacheKey("*", namespaceName, environment, configName);
            this.redisService.syncLock(configCacheKey, () -> {
                LOGGER.info("\u5f85\u6e05\u7406\u7684\u914d\u7f6eKEY\uff1a{}", (Object)configCacheKey);
                this.redisService.deleteList(this.redisService.getKeys(configCacheKey));
                String moduleName = object.optString("moduleName", null);
                if (moduleName != null) {
                    String configModuleMappingKey = LiuLiConfigService.getConfigModuleMappingKey("*", namespaceName, environment, moduleName);
                    this.redisService.deleteList(this.redisService.getKeys(configModuleMappingKey));
                }
                LRUCache<String, JSONObject> cache = LiuLiConfigService.getLiuliConfigLocalCache();
                List<String> keys = cache.keySet().stream().filter(str -> this.isMatch((String)str, configCacheKey)).toList();
                keys.forEach(arg_0 -> cache.remove(arg_0));
                return null;
            });
        });
    }

    private boolean isMatch(String ss, String pp) {
        int n = ((String)ss).length();
        int m = ((String)pp).length();
        ss = " " + (String)ss;
        pp = " " + (String)pp;
        char[] s = ((String)ss).toCharArray();
        char[] p = ((String)pp).toCharArray();
        boolean[][] f = new boolean[n + 1][m + 1];
        f[0][0] = true;
        for (int i = 0; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                f[i][j] = p[j] == '*' ? f[i][j - 1] || i - 1 >= 0 && f[i - 1][j] : i - 1 >= 0 && f[i - 1][j - 1] && (s[i] == p[j] || p[j] == '?');
            }
        }
        return f[n][m];
    }
}

