package com.af.v4.system.common.liuli.utils.enums;

import java.util.stream.Stream;

/**
 * 操作系统类型
 *
 * @author Mr.river
 */
public enum OSTypeEnum {
    // Windows
    WINDOWS("Windows"),
    // Linux
    LINUX("Linux");

    private final String value;

    OSTypeEnum(String value) {
        this.value = value;
    }

    public static OSTypeEnum toType(String value) {
        return Stream.of(OSTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
