package com.af.v4.system.common.liuli.api;

import com.af.v4.system.common.liuli.config.LiuLiClientConfig;
import org.springframework.stereotype.Component;

@Component
public class LiuLiApi {

    private final LiuLiClientConfig liuLiClientConfig;

    private static final String SEVER_URL = "https://liuli.aofengcloud.com:31467/api";

    public LiuLiApi(LiuLiClientConfig liuLiClientConfig) {
        this.liuLiClientConfig = liuLiClientConfig;
    }

    public String getApiUrl() {
        return liuLiClientConfig.getApiUrl() != null ? liuLiClientConfig.getApiUrl() : SEVER_URL;
    }

    /**
     * 获取客户端配置
     */
    public String getConfigUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/getConfigByClientV2";
    }

    /**
     * 批量获取客户端配置
     */
    public String getBatchConfigUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/batchGetConfigByClient";
    }

    /**
     * 解析客户端配置
     */
    public String getParseConfigUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/parseConfigByClientV2";
    }

    /**
     * 上报应用错误日志
     */
    public String getUploadErrorLogUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/uploadErrorLog";
    }

    /**
     * 上报运行时错误记录
     */
    public String getUploadRuntimeErrorRecordUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/uploadRuntimeErrorRecord";
    }

    /**
     * 上报表数据统计信息
     */
    public String getUploadTableInfoUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/uploadTableInfo";
    }

    /**
     * 上报应用心跳
     */
    public String getUploadHeartbeatUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/uploadHeartBeat";
    }

    /**
     * 保存生产环境应用信息
     */
    public String getSaveApplicationInfoUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/saveApplicationInfo";
    }

    /**
     * 检查琉璃架构版本
     */
    public String getCheckV4VersionUrl() {
        return STR."\{getApiUrl()}/af-liuli/logic/openapi/checkV4Version";
    }
}
