/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.service;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.LRUCache;
import cn.hutool.core.util.StrUtil;
import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.liuli.api.LiuLiApi;
import com.af.v4.system.common.liuli.application.service.GlazeApplicationService;
import com.af.v4.system.common.liuli.config.LiuLiClientConfig;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import com.af.v4.system.common.plugins.core.SecureTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.http.config.CloseHttpLogHandler;
import com.af.v4.system.common.redis.RedisService;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class LiuLiConfigService
implements ILiuLiConfigServiceProxy {
    private static final String AES_KEY = "kxYiWjt/cmRRYaCOT9asaw==";
    private static final LRUCache<String, JSONObject> LIULI_CONFIG_LOCAL_CACHE = CacheUtil.newLRUCache((int)200);
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiConfigService.class);
    private static final Integer CONFIG_NOT_FOUND_CODE = 406;
    private static final Integer CONFIG_OTHER_ERROR_CODE = 416;
    private static EnvType envType = null;
    private final LiuLiClientConfig liuLiClientConfig;
    private final GlazeApplicationService applicationService;
    private final RedisService redisService;
    private final DynamicFeignClientFactory dynamicFeignClientFactory;
    private final LiuLiApi liuLiApi;

    public LiuLiConfigService(LiuLiClientConfig liuLiClientConfig, GlazeApplicationService applicationService, RedisService redisService, DynamicFeignClientFactory dynamicFeignClientFactory, LiuLiApi liuLiApi) {
        this.liuLiClientConfig = liuLiClientConfig;
        this.applicationService = applicationService;
        this.redisService = redisService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        envType = applicationService.getEnvType();
        this.liuLiApi = liuLiApi;
    }

    public static String getConfigCacheKey(String tenantName, String namespaceName, String environment, String configName) {
        return "LiuLiConfigCache@" + tenantName + "_" + namespaceName + "_" + environment + "_" + configName;
    }

    public static String getConfigCacheBakKey(String tenantName, String namespaceName, String environment, String configName) {
        return "LiuLiConfigCacheBak@" + tenantName + "_" + namespaceName + "_" + environment + "_" + configName;
    }

    public static String getConfigModuleMappingKey(String tenantName, String namespaceName, String environment, String moduleName) {
        return "LiuLiConfigModuleMapping@" + tenantName + "_" + namespaceName + "_" + environment + "_" + moduleName;
    }

    public static String getConfigModuleMappingBakKey(String tenantName, String namespaceName, String environment, String moduleName) {
        return "LiuLiConfigModuleMappingBak@" + tenantName + "_" + namespaceName + "_" + environment + "_" + moduleName;
    }

    public static LRUCache<String, JSONObject> getLiuliConfigLocalCache() {
        return LIULI_CONFIG_LOCAL_CACHE;
    }

    public static String getAesKey() {
        return AES_KEY;
    }

    public JSONObject get(String configName) {
        return this.get(configName, false);
    }

    public JSONObject getBySelf(String configName) {
        return this.get(configName, SearchMode.BY_CONFIG_NAME, false, false);
    }

    public JSONObject getByModule(String moduleName) {
        return this.getByModule(moduleName, false);
    }

    public JSONObject get(String name, SearchMode searchMode, Boolean isThrowExceptionOnConfigNotFound, Boolean shouldGetConfigByParent) {
        if (name == null) {
            if (searchMode == SearchMode.BY_CONFIG_NAME) {
                LOGGER.error("\u914d\u7f6e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (searchMode == SearchMode.BY_MODULE_NAME) {
                LOGGER.error("\u6a21\u5757\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return null;
        }
        Supplier<JSONObject> fun = () -> this.getConfigByRequest(name, searchMode, shouldGetConfigByParent, result -> {
            if (!isThrowExceptionOnConfigNotFound.booleanValue()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a{}", result);
                }
                String tenantName = this.applicationService.getOrgName();
                String namespaceName = this.applicationService.getApplicationName();
                String environment = this.applicationService.getEnvType().getValue();
                if (result.getCode() == CONFIG_NOT_FOUND_CODE.intValue()) {
                    this.addCache(tenantName, namespaceName, environment, name, EmptyJSONObject.SELF);
                }
                return null;
            }
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        }, true);
        JSONObject configInfo = searchMode == SearchMode.BY_MODULE_NAME ? this.getConfigsByConfigModuleMapping(name, key -> (JSONObject)this.redisService.syncLock(key, () -> this.lambda$get$3(name, (Supplier)fun))) : this.getConfigByCache(name, key -> (JSONObject)this.redisService.syncLock(key, () -> this.lambda$get$6(name, (Supplier)fun)));
        return this.isEmptyCache(configInfo) ? null : new JSONObject(configInfo.toString());
    }

    public JSONObject get(String configName, Boolean isThrowExceptionOnConfigNotFound) {
        return this.get(configName, SearchMode.BY_CONFIG_NAME, isThrowExceptionOnConfigNotFound, true);
    }

    public JSONObject getByModule(String moduleName, Boolean isThrowExceptionOnConfigNotFound) {
        JSONObject configResult = this.get(moduleName, SearchMode.BY_MODULE_NAME, isThrowExceptionOnConfigNotFound, true);
        if (configResult == null) {
            return null;
        }
        JSONArray configs = configResult.optJSONArray("items");
        if (configs == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        configs.forEach(value -> {
            JSONObject valueObj = (JSONObject)value;
            result.put(valueObj.getJSONObject("$globalProp").getString("name"), (Object)valueObj);
        });
        return result;
    }

    private JSONObject getConfigByCache(String configName, Function<String, JSONObject> notFoundFun) {
        JSONObject cacheConfigContent;
        boolean hasConfig;
        String tenantName = this.applicationService.getOrgName();
        String namespaceName = this.applicationService.getApplicationName();
        String environment = envType.getValue();
        String configCacheKey = LiuLiConfigService.getConfigCacheKey(tenantName, namespaceName, environment, configName);
        if (envType == EnvType.LOCAL) {
            return notFoundFun.apply(configCacheKey);
        }
        JSONObject configContent = (JSONObject)LIULI_CONFIG_LOCAL_CACHE.get((Object)configCacheKey);
        if (configContent != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}:\u901a\u8fc7localCache\u83b7\u53d6\u5230\u7409\u7483\u914d\u7f6e[{}]\uff1a{}", new Object[]{configCacheKey, configName, configContent});
            }
            return configContent;
        }
        configContent = (JSONObject)this.redisService.get(configCacheKey);
        boolean bl = hasConfig = configContent != null;
        if (hasConfig) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}:\u901a\u8fc7redis\u83b7\u53d6\u5230\u7409\u7483\u914d\u7f6e[{}]\uff1a{}", new Object[]{configCacheKey, configName, configContent});
            }
        } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            String backKey = LiuLiConfigService.getConfigCacheBakKey(tenantName, namespaceName, environment, configName);
            configContent = (JSONObject)this.redisService.get(backKey);
            boolean bl2 = hasConfig = configContent != null;
            if (hasConfig) {
                this.printWarnInfo(backKey, configContent.toString());
            }
        }
        if (!hasConfig) {
            return notFoundFun.apply(configCacheKey);
        }
        if (!this.isEmptyCache(configContent)) {
            JSONObject targetConfigGlobalProp = configContent.getJSONObject("$globalProp");
            String targetConfigTenantName = targetConfigGlobalProp.getString("tenantAlias");
            String targetConfigCacheKey = LiuLiConfigService.getConfigCacheKey(targetConfigTenantName, namespaceName, environment, configName);
            cacheConfigContent = this.reuseConfigObject(configContent, (JSONObject)LIULI_CONFIG_LOCAL_CACHE.get((Object)targetConfigCacheKey));
        } else {
            cacheConfigContent = configContent;
        }
        LIULI_CONFIG_LOCAL_CACHE.put((Object)configCacheKey, (Object)cacheConfigContent);
        return cacheConfigContent;
    }

    private boolean isEmptyCache(JSONObject cacheObj) {
        return cacheObj == null || cacheObj instanceof EmptyJSONObject;
    }

    private JSONObject getConfigsByConfigModuleMapping(String moduleName, Function<String, JSONObject> notFoundFun) {
        String tenantName = this.applicationService.getOrgName();
        String namespaceName = this.applicationService.getApplicationName();
        String environment = envType.getValue();
        String key = LiuLiConfigService.getConfigModuleMappingKey(tenantName, namespaceName, environment, moduleName);
        if (envType == EnvType.LOCAL) {
            return notFoundFun.apply(key);
        }
        String configs = (String)this.redisService.get(key);
        if (configs == null) {
            if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
                String backKey = LiuLiConfigService.getConfigModuleMappingBakKey(tenantName, namespaceName, environment, moduleName);
                configs = (String)this.redisService.get(backKey);
                if (configs == null) {
                    return notFoundFun.apply(key);
                }
                this.printWarnInfo(backKey, configs);
            } else {
                return notFoundFun.apply(key);
            }
        }
        List configNameArray = StrUtil.split((CharSequence)configs, (CharSequence)",");
        JSONObject configResult = new JSONObject();
        JSONArray resolveResultArray = new JSONArray();
        configResult.put("items", (Object)resolveResultArray);
        for (String configName : configNameArray) {
            JSONObject configObj = this.get(configName);
            if (configObj == null) continue;
            resolveResultArray.put((Object)configObj);
        }
        return configResult;
    }

    private JSONObject getConfigByDatabase(String configName, Supplier<JSONObject> notFoundFun) {
        if (envType == EnvType.LOCAL) {
            return notFoundFun.get();
        }
        String tenantName = this.applicationService.getOrgName();
        String namespaceName = this.applicationService.getApplicationName();
        String environment = this.applicationService.getEnvType().getValue();
        JSONObject params = new JSONObject();
        params.put("tenantName", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            R result = remoteLogicService.run("getLiuLiConfig", params.toString(), "inner");
            if (result.getCode() == 200) {
                JSONObject response = result.parseResponseJson();
                String contentStr = response.getJSONObject("data").optString("content", null);
                if (contentStr != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u901a\u8fc7\u6570\u636e\u5e93\u83b7\u53d6\u7409\u7483\u914d\u7f6e[{}]\uff1a{}", (Object)configName, (Object)contentStr);
                    }
                    JSONObject content = new JSONObject(contentStr);
                    this.addCache(tenantName, namespaceName, environment, configName, content);
                    return content;
                }
            } else {
                LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u51fa\u9519\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)result.getCode(), (Object)result.getMsg());
            }
        }
        catch (Throwable e) {
            LOGGER.error("af-system\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return notFoundFun.get();
    }

    private JSONObject getConfigByRequest(String name, SearchMode searchMode, Boolean shouldGetConfigByParent, Function<R<JSONObject>, JSONObject> notFoundFun, Boolean isPrecompile) {
        R result;
        String url;
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return notFoundFun.apply((R<JSONObject>)R.fail((String)"\u5f53\u524d\u5904\u4e8e\u79bb\u7ebf\u6a21\u5f0f"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u901a\u8fc7\u7409\u7483\u4e2d\u5fc3\u83b7\u53d6\u914d\u7f6e[{}]", (Object)name);
        }
        String tenantName = this.applicationService.getOrgName();
        String namespaceName = this.applicationService.getApplicationName();
        String environment = this.applicationService.getEnvType().getValue();
        JSONObject params = new JSONObject();
        params.put("tenantUUID", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("shouldGetConfigByParent", (Object)shouldGetConfigByParent);
        params.put("dbType", (Object)DynamicDataSource.getDbType().name());
        if (searchMode == SearchMode.BY_MODULE_NAME) {
            params.put("moduleName", (Object)name);
            url = this.liuLiApi.getBatchConfigUrl();
        } else {
            params.put("configName", (Object)name);
            url = this.liuLiApi.getConfigUrl();
        }
        if (namespaceName.equals("af-liuli")) {
            try {
                Object localResult = ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("getConfigByClientV2", params);
                result = R.ok((Object)((JSONObject)localResult));
            }
            catch (ServiceException e) {
                result = R.build((ServiceException)e);
            }
        } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
            RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
            R remoteResult = searchMode == SearchMode.BY_MODULE_NAME ? remoteLiuLiService.batchGetConfigByClient(params.toString(), "inner") : remoteLiuLiService.getConfigByClient(params.toString(), "inner");
            result = R.build((JSONObject)remoteResult.parseResponseJson());
        } else {
            try (CloseHttpLogHandler logHandler = CloseHttpLogHandler.build();){
                if (this.applicationService.getEnvType() == EnvType.PROD) {
                    logHandler.apply();
                }
                String cloudConfig = RestTools.post((String)url, (JSONObject)params);
                result = R.build((JSONObject)new JSONObject(cloudConfig));
            }
        }
        if (result.getCode() == 200) {
            String plainText = ((JSONObject)result.getData()).getString("plainStr");
            JSONObject data = new JSONObject(SecureTools.AESDecrypt((String)plainText, (String)AES_KEY));
            if (searchMode == SearchMode.BY_CONFIG_NAME) {
                return this.resolveConfig(data, isPrecompile);
            }
            JSONObject configResult = new JSONObject();
            JSONArray resolveResultArray = new JSONArray();
            JSONArray configArray = data.getJSONArray("items");
            if (!configArray.isEmpty()) {
                StringBuilder configsBuilder = new StringBuilder();
                configArray.forEach(config -> {
                    JSONObject configObj = (JSONObject)config;
                    resolveResultArray.put((Object)this.resolveConfig(configObj, isPrecompile));
                    String configName = configObj.getString("name");
                    configsBuilder.append(configName).append(",");
                });
                configsBuilder.deleteCharAt(configsBuilder.length() - 1);
                this.addConfigModuleMapping(tenantName, namespaceName, environment, name, configsBuilder.toString());
            }
            configResult.put("items", (Object)resolveResultArray);
            return configResult;
        }
        return notFoundFun.apply((R<JSONObject>)result);
    }

    private JSONObject resolveConfig(JSONObject response, boolean isPrecompile) {
        JSONObject content = isPrecompile ? response.getJSONObject("realContent") : response.getJSONObject("content");
        String name = response.getString("name");
        String module = response.optString("module", "null");
        String version = response.optString("version", "null");
        JSONObject tenant = response.optJSONObject("tenant");
        JSONObject namespace = response.optJSONObject("namespace");
        content.put("$globalProp", (Object)new JSONObject().put("name", (Object)name).put("module", (Object)module).put("environment", (Object)envType.getValue()).put("version", (Object)version).put("namespaceName", (Object)(namespace != null ? namespace.getString("f_namespace_name") : "null")).put("tenantAlias", (Object)(tenant != null ? tenant.getString("f_tenant_uuid") : "null")));
        if (!content.has("$configProp")) {
            content.put("$configProp", (Object)new JSONObject());
        }
        String configName = response.getString("name");
        String tenantName = this.applicationService.getOrgName();
        String namespaceName = this.applicationService.getApplicationName();
        String environment = envType.getValue();
        this.addCache(tenantName, namespaceName, environment, configName, content);
        this.addDatabase(tenantName, namespaceName, environment, configName, content);
        return content;
    }

    public JSONObject parseConfigByRequest(String configType, Object configContent) {
        R result;
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u901a\u8fc7\u7409\u7483\u4e2d\u5fc3\u89e3\u6790\u914d\u7f6e");
        }
        JSONObject params = new JSONObject().put("configType", (Object)configType).put("configContent", configContent);
        String namespaceName = this.applicationService.getApplicationName();
        if (namespaceName.equals("af-liuli")) {
            try {
                Object localResult = ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("getConfigByClientV2", params);
                result = R.ok((Object)((JSONObject)localResult));
            }
            catch (ServiceException e) {
                result = R.build((ServiceException)e);
            }
        } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
            RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
            R remoteResult = remoteLiuLiService.parseConfigByClient(params.toString(), "inner");
            result = R.build((JSONObject)remoteResult.parseResponseJson());
        } else {
            try (CloseHttpLogHandler logHandler = CloseHttpLogHandler.build();){
                if (this.applicationService.getEnvType() == EnvType.PROD) {
                    logHandler.apply();
                }
                String cloudConfig = RestTools.post((String)this.liuLiApi.getParseConfigUrl(), (JSONObject)params);
                result = R.build((JSONObject)new JSONObject(cloudConfig));
            }
        }
        if (result.getCode() == 200) {
            String plainText = ((JSONObject)result.getData()).getString("plainStr");
            return new JSONObject(SecureTools.AESDecrypt((String)plainText, (String)AES_KEY));
        }
        return result.parseResponseJson();
    }

    public JSONObject getNativeConfigByRequest(String configName) {
        return this.getConfigByRequest(configName, SearchMode.BY_CONFIG_NAME, true, result -> {
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        }, false);
    }

    private void addCache(String tenantName, String namespaceName, String environment, String configName, JSONObject content) {
        if (envType == EnvType.LOCAL) {
            return;
        }
        String configCacheKey = LiuLiConfigService.getConfigCacheKey(tenantName, namespaceName, environment, configName);
        String configCacheBakKey = LiuLiConfigService.getConfigCacheBakKey(tenantName, namespaceName, environment, configName);
        LIULI_CONFIG_LOCAL_CACHE.put((Object)configCacheKey, (Object)content);
        this.redisService.set(configCacheKey, (Object)content);
        this.redisService.set(configCacheBakKey, (Object)content);
    }

    private void addDatabase(String tenantName, String namespaceName, String environment, String configName, JSONObject content) {
        if (envType == EnvType.LOCAL) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("tenantName", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        params.put("configContent", (Object)content);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            remoteLogicService.run("addLiuLiConfig", params.toString(), "inner");
        }
        catch (Throwable e) {
            LOGGER.error("af-system\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void addConfigModuleMapping(String tenantName, String namespaceName, String environment, String moduleName, String configs) {
        if (envType == EnvType.LOCAL) {
            return;
        }
        String configModuleMappingKey = LiuLiConfigService.getConfigModuleMappingKey(tenantName, namespaceName, environment, moduleName);
        String configModuleMappingBakKey = LiuLiConfigService.getConfigModuleMappingBakKey(tenantName, namespaceName, environment, moduleName);
        this.redisService.set(configModuleMappingKey, (Object)configs);
        this.redisService.set(configModuleMappingBakKey, (Object)configs);
    }

    public void removeCache(String namespaceName, String environment, String configName, String moduleName) {
        String configCacheKey = LiuLiConfigService.getConfigCacheKey("*", namespaceName, environment, configName);
        this.redisService.deleteList(this.redisService.getKeys(configCacheKey));
        if (moduleName != null) {
            String configModuleMappingKey = LiuLiConfigService.getConfigModuleMappingKey("*", namespaceName, environment, moduleName);
            this.redisService.deleteList(this.redisService.getKeys(configModuleMappingKey));
        }
        RTopic clientTopic = this.redisService.getTopic("Topic_LiuLi_ClearCache");
        clientTopic.publishAsync((Object)new JSONObject().put("namespaceName", (Object)namespaceName).put("environment", (Object)environment).put("configName", (Object)configName).put("moduleName", (Object)moduleName));
    }

    public void removeCache(String namespaceName, String environment, String configName) {
        this.removeCache(namespaceName, environment, configName, "*");
    }

    public void removeCacheKeys(String namespaceName, String environment, List<String> cacheKeys) {
        for (String key : cacheKeys) {
            this.removeCache(namespaceName, "prod", key);
        }
    }

    private void printWarnInfo(String backKey, String configs) {
        LOGGER.warn("**\u79bb\u7ebf\u5b89\u5168\u6a21\u5f0f**\uff1a\u4ece\u5feb\u7167\u5907\u4efd\u4e2d\u5f97\u5230[{}]\u914d\u7f6e\uff1a{}", (Object)backKey, (Object)configs);
    }

    private JSONObject reuseConfigObject(JSONObject newConfig, JSONObject existingConfig) {
        if (this.isEmptyCache(existingConfig)) {
            return newConfig;
        }
        int existingVersion = Integer.parseInt(existingConfig.getJSONObject("$globalProp").optString("version", "0"));
        int newVersion = Integer.parseInt(newConfig.getJSONObject("$globalProp").optString("version", "1"));
        return newVersion > existingVersion ? newConfig : existingConfig;
    }

    private /* synthetic */ JSONObject lambda$get$6(String name, Supplier fun) {
        return this.getConfigByCache(name, arg_0 -> this.lambda$get$5(name, (Supplier)fun, arg_0));
    }

    private /* synthetic */ JSONObject lambda$get$5(String name, Supplier fun, String key2) {
        return this.getConfigByDatabase(name, fun);
    }

    private /* synthetic */ JSONObject lambda$get$3(String name, Supplier fun) {
        return this.getConfigsByConfigModuleMapping(name, arg_0 -> LiuLiConfigService.lambda$get$2((Supplier)fun, arg_0));
    }

    private static /* synthetic */ JSONObject lambda$get$2(Supplier fun, String key2) {
        return (JSONObject)fun.get();
    }

    public static enum SearchMode {
        BY_CONFIG_NAME,
        BY_MODULE_NAME;

    }

    private static class EmptyJSONObject
    extends JSONObject {
        public static final EmptyJSONObject SELF = new EmptyJSONObject();

        private EmptyJSONObject() {
        }

        public String toString() {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }
    }
}

