package com.af.v4.system.common.liuli.dict.service;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiDictServiceProxy;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 琉璃-字典服务
 *
 * @author Mr.river
 */
@Primary
@Service
public class LiuLiDictService implements ILiuLiDictServiceProxy {

    private final LiuLiConfigService liuLiConfigService;

    public LiuLiDictService(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
    }

    /**
     * 根据字典类型和字典标签获取字典值
     *
     * @param dictType  字典类型
     * @param dictLabel 字典标签
     * @return 字典值
     */
    public String getDictValue(String dictType, String dictLabel) {
        return this.getAllDictByDictType(dictType, 1).get(dictLabel);
    }

    /**
     * 根据字典类型和字典值获取字典标签
     *
     * @param dictType  字典类型
     * @param dictValue 字典值
     * @return 字典值
     */
    public String getDictLabel(String dictType, String dictValue) {
        try {
            return this.getAllDictByDictType(dictType).get(dictValue);
        } catch (Exception e) {
            return dictValue;
        }
    }

    /**
     * 获取字典下所有的字典值与标签
     *
     * @param dictType 字典类型
     * @param type     返回类型
     * @return type为0时 dictValue为key，dictLabel为值组成的Map，type为1时 dictLabel为key，dictValue为值组成的Map
     */
    public Map<String, String> getAllDictByDictType(String dictType, Integer type) {
        JSONArray list = liuLiConfigService.get(dictType, true).getJSONArray("value");
        Map<String, String> dictMap = new HashMap<>(list.length());
        list.forEach(item -> {
            JSONObject itemObj = (JSONObject) item;
            if (type == 0) {
                dictMap.put(itemObj.get("value").toString(), itemObj.getString("label"));
            } else {
                dictMap.put(itemObj.get("label").toString(), itemObj.getString("value"));
            }
        });
        return dictMap;
    }

    public Map<String, String> getAllDictByDictType(String dictType) {
        return getAllDictByDictType(dictType, 0);
    }
}
