package com.af.v4.system.common.liuli.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * 琉璃客户端配置
 *
 * @author Mr.river
 * @since 1.1.18
 */
@Configuration
@ConfigurationProperties(prefix = "liuli")
@Component
public class LiuLiClientConfig {

    private static final Logger logger = LoggerFactory.getLogger(LiuLiClientConfig.class);

    /**
     * 运行模式
     */
    private LiuLiClientOperationalModeEnum liuLiClientOperationalMode;
    /**
     * 心跳开关
     */
    private Boolean heartbeat;
    /**
     * 上报错误日志开关
     */
    private Boolean uploadErrorLog;

    public Boolean getHeartbeat() {
        if (heartbeat == null) {
            heartbeat = true;
        }
        return heartbeat;
    }

    public void setHeartbeat(Boolean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public Boolean getUploadErrorLog() {
        if (uploadErrorLog == null) {
            uploadErrorLog = true;
        }
        return uploadErrorLog;
    }

    public void setUploadErrorLog(Boolean uploadErrorLog) {
        this.uploadErrorLog = uploadErrorLog;
    }

    public LiuLiClientOperationalModeEnum getLiuLiClientOperationalMode() {
        if (liuLiClientOperationalMode == null) {
            liuLiClientOperationalMode = LiuLiClientOperationalModeEnum.NORMAL;
        }
        return liuLiClientOperationalMode;
    }

    public void setLiuLiClientOperationalMode(String liuLiClientOperationalMode) {
        this.liuLiClientOperationalMode = LiuLiClientOperationalModeEnum.toType(liuLiClientOperationalMode);
        if (this.liuLiClientOperationalMode == null) {
            throw new ServiceException("琉璃客户端运行模式错误：" + liuLiClientOperationalMode);
        } else if (this.liuLiClientOperationalMode == LiuLiClientOperationalModeEnum.OFFLINE) {
            logger.warn("已开启琉璃客户端**离线安全模式**，该模式下所有业务将不再尝试访问琉璃中心，且配置可能会从快照备份中获取，所造成的业务风险需自行承担！");
        }
    }
}
