/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.monitor.service;

import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.liuli.config.LiuLiClientConfig;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestAsyncTools;
import com.af.v4.system.common.plugins.http.config.HttpRuntimeSupport;
import com.af.v4.system.common.plugins.http.core.response.EmptyAsyncResponse;
import com.af.v4.system.common.plugins.http.core.response.StandardAsyncResponse;
import com.af.v4.system.common.redis.RedisService;
import jakarta.annotation.PostConstruct;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiuLiMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiMonitorService.class);
    private final ApplicationUtils applicationUtils;
    private final LiuLiClientConfig liuLiClientConfig;
    private final RedisService redisService;
    private final DynamicFeignClientFactory dynamicFeignClientFactory;

    public LiuLiMonitorService(ApplicationUtils applicationUtils, LiuLiClientConfig liuLiClientConfig, RedisService redisService, DynamicFeignClientFactory dynamicFeignClientFactory) {
        this.applicationUtils = applicationUtils;
        this.liuLiClientConfig = liuLiClientConfig;
        this.redisService = redisService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
    }

    public static String geApplicationLockKey(String namespaceName) {
        return "LiuLiApplication@" + namespaceName;
    }

    @PostConstruct
    public void init() {
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        EnvType envType = this.applicationUtils.getEnvType();
        if (envType == EnvType.DEV) {
            this.checkV4Version();
        } else if (envType == EnvType.PROD) {
            this.uploadApplicationInfo();
        }
    }

    private void uploadApplicationInfo() {
        String applicationName = this.applicationUtils.getApplicationName();
        if (applicationName.equals("af-liuli") || applicationName.equals("af-runtime")) {
            return;
        }
        String applicationLockKey = LiuLiMonitorService.geApplicationLockKey(applicationName);
        try {
            this.redisService.lock(applicationLockKey, Integer.valueOf(60), Integer.valueOf(300), () -> {
                JSONObject params = new JSONObject().put("tenantUUID", (Object)this.applicationUtils.getTenantName()).put("name", (Object)applicationName).put("coreVersion", (Object)ApplicationUtils.getSystemV4Version()).put("applicationVersion", (Object)ApplicationUtils.getAppVersion()).put("lastStartDate", (Object)DateTools.getNow2());
                StandardAsyncResponse.SuccessHandler handler = response -> {
                    R result = R.build((JSONObject)new JSONObject(response));
                    if (!result.isSuccess().booleanValue()) {
                        LOGGER.warn("\u5e94\u7528\u4fe1\u606f\u4e0a\u4f20\u5931\u8d25:{}", (Object)result.getMsg());
                    }
                };
                if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                    RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                    R remoteResult = remoteLiuLiService.saveApplicationInfo(params.toString(), "inner");
                    handler.run(remoteResult.parseResponseJson().toString());
                } else {
                    try {
                        HttpRuntimeSupport.disableLogPrint();
                        RestAsyncTools.post((String)"http://aote-office.8866.org:31467/api/af-liuli/logic/openapi/saveApplicationInfo", (String)params.toString(), null, (FutureCallback)new StandardAsyncResponse(handler, e -> LOGGER.error("\u5e94\u7528\u4fe1\u606f\u4e0a\u4f20\u5931\u8d25:{}", (Object)e.getMessage())));
                    }
                    finally {
                        HttpRuntimeSupport.enableLogPrint();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadLogicErrorLog(JSONObject operLog) {
        if (!this.liuLiClientConfig.getUploadErrorLog().booleanValue()) {
            return;
        }
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        EnvType envType = this.applicationUtils.getEnvType();
        if (envType == EnvType.DEV) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", (Object)this.applicationUtils.getTenantName());
        jsonObject.put("applicationName", (Object)this.applicationUtils.getApplicationName());
        jsonObject.put("applicationVersion", (Object)ApplicationUtils.getAppVersion());
        jsonObject.put("coreVersion", (Object)ApplicationUtils.getSystemV4Version());
        jsonObject.put("osType", (Object)ApplicationUtils.getOSType());
        jsonObject.put("environment", (Object)this.applicationUtils.getEnvType().getValue());
        jsonObject.put("method", operLog.opt("f_method"));
        jsonObject.put("requestMethod", operLog.opt("f_request_method"));
        jsonObject.put("operIp", operLog.opt("f_oper_ip"));
        jsonObject.put("operUrl", operLog.opt("f_oper_url"));
        jsonObject.put("operName", operLog.opt("f_oper_name"));
        jsonObject.put("operParam", operLog.opt("f_oper_param"));
        jsonObject.put("jsonResult", operLog.opt("f_json_result"));
        jsonObject.put("errorMsg", operLog.opt("f_error_msg"));
        jsonObject.put("businessTitle", operLog.opt("f_title"));
        jsonObject.put("businessType", operLog.opt("f_business_type"));
        jsonObject.put("operatorType", operLog.opt("f_operator_type"));
        jsonObject.put("costTime", operLog.opt("f_cost_time"));
        HttpRuntimeSupport.disableLogPrint();
        try {
            if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                remoteLiuLiService.uploadErrorLog(jsonObject.toString(), "inner");
            } else {
                RestAsyncTools.post((String)"http://aote-office.8866.org:31467/api/af-liuli/logic/openapi/uploadErrorLog", (String)jsonObject.toString(), null, (FutureCallback)new EmptyAsyncResponse());
            }
        }
        finally {
            HttpRuntimeSupport.enableLogPrint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkV4Version() {
        String nowVersion = ApplicationUtils.getSystemV4Version();
        if (nowVersion == null) {
            return;
        }
        LOGGER.info("\ud83c\udf89\ud83c\udf89\ud83c\udf89\u6b22\u8fce\u4f7f\u7528\u7409\u7483\u67b6\u6784\uff0c\u7248\u672c\uff1aV{}", (Object)nowVersion);
        String applicationName = this.applicationUtils.getApplicationName();
        if (applicationName.equals("af-liuli") || applicationName.equals("af-runtime")) {
            return;
        }
        JSONObject params = new JSONObject().put("version", (Object)nowVersion);
        StandardAsyncResponse.SuccessHandler handler = response -> {
            R result = R.build((JSONObject)new JSONObject(response));
            if (result.isSuccess().booleanValue()) {
                if (((JSONObject)result.getData()).getBoolean("hasUpdate")) {
                    LOGGER.warn(((JSONObject)result.getData()).getString("msg"));
                }
            } else {
                LOGGER.warn("\u68c0\u67e5\u7409\u7483\u67b6\u6784\u7248\u672c\u5931\u8d25:{}", (Object)result.getMsg());
            }
        };
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
            RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
            R remoteResult = remoteLiuLiService.checkV4Version(params.toString(), "inner");
            handler.run(remoteResult.parseResponseJson().toString());
        } else {
            HttpRuntimeSupport.disableLogPrint();
            try {
                RestAsyncTools.post((String)"http://aote-office.8866.org:31467/api/af-liuli/logic/openapi/checkV4Version", (String)params.toString(), null, (FutureCallback)new StandardAsyncResponse(handler, e -> LOGGER.error("\u68c0\u67e5\u7409\u7483\u67b6\u6784\u7248\u672c\u5931\u8d25:{}", (Object)e.getMessage())));
            }
            finally {
                HttpRuntimeSupport.enableLogPrint();
            }
        }
    }

    public void uploadHeartbeat() {
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        if (!this.liuLiClientConfig.getHeartbeat().booleanValue()) {
            return;
        }
        String applicationName = this.applicationUtils.getApplicationName();
        if (applicationName.equals("af-liuli") || applicationName.equals("af-runtime")) {
            return;
        }
        String applicationLockKey = LiuLiMonitorService.geApplicationLockKey(applicationName);
        try {
            this.redisService.lock(applicationLockKey, Integer.valueOf(60), Integer.valueOf(300), () -> {
                JSONObject params = new JSONObject().put("tenantUUID", (Object)this.applicationUtils.getTenantName()).put("name", (Object)applicationName);
                StandardAsyncResponse.SuccessHandler handler = response -> {
                    R result = R.build((JSONObject)new JSONObject(response));
                    if (!result.isSuccess().booleanValue()) {
                        LOGGER.warn("\u5fc3\u8df3\u4e0a\u4f20\u5931\u8d25:{}", (Object)result.getMsg());
                    }
                };
                if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                    RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                    R remoteResult = remoteLiuLiService.uploadHeartBeat(params.toString(), "inner");
                    handler.run(remoteResult.parseResponseJson().toString());
                } else {
                    try {
                        HttpRuntimeSupport.disableLogPrint();
                        RestAsyncTools.post((String)"http://aote-office.8866.org:31467/api/af-liuli/logic/openapi/uploadHeartBeat", (String)params.toString(), null, (FutureCallback)new StandardAsyncResponse(handler, e -> LOGGER.error("\u5fc3\u8df3\u4e0a\u4f20\u5931\u8d25:{}", (Object)e.getMessage())));
                    }
                    finally {
                        HttpRuntimeSupport.enableLogPrint();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

