/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.dict.service;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class LiuLiDictService {
    private final LiuLiConfigService liuLiConfigService;

    public LiuLiDictService(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
    }

    public String getDictValue(String dictType, String dictLabel) {
        return this.getAllDictByDictType(dictType, 1).get(dictLabel);
    }

    public String getDictLabel(String dictType, String dictValue) {
        return this.getAllDictByDictType(dictType).get(dictValue);
    }

    public Map<String, String> getAllDictByDictType(String dictType, Integer type) {
        JSONArray list = this.liuLiConfigService.get(dictType, true).getJSONArray("source");
        HashMap<String, String> dictMap = new HashMap<String, String>(list.length());
        list.forEach(item -> {
            JSONObject itemObj = (JSONObject)item;
            if (type == 0) {
                dictMap.put(itemObj.get("value").toString(), itemObj.getString("label"));
            } else {
                dictMap.put(itemObj.get("label").toString(), itemObj.getString("value"));
            }
        });
        return dictMap;
    }

    public Map<String, String> getAllDictByDictType(String dictType) {
        return this.getAllDictByDictType(dictType, 0);
    }
}

