/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.utils;

import com.af.v4.system.common.redis.RedisService;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class LiuLiUtil {
    private static final String CLOUD_URL_KEY = "LiuLiConfigCache@CloudUrl";
    private static final String DEFAULT_CLOUD_URL = "http://aote-office.f3322.net:31039";
    private final RedisService redisService;

    public LiuLiUtil(RedisService redisService) {
        this.redisService = redisService;
    }

    public String getCloudUrl() {
        String cloudUrl;
        JSONObject url = (JSONObject)this.redisService.get(CLOUD_URL_KEY);
        if (url == null) {
            cloudUrl = DEFAULT_CLOUD_URL;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cloudUrl", (Object)cloudUrl);
            this.redisService.set(CLOUD_URL_KEY, (Object)jsonObject);
        } else {
            cloudUrl = url.getString("cloudUrl");
        }
        return cloudUrl;
    }

    public void updateCloudUrl(String cloudUrl) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cloudUrl", (Object)cloudUrl);
        this.redisService.lock(CLOUD_URL_KEY, () -> this.redisService.set(CLOUD_URL_KEY, (Object)jsonObject));
    }
}

