/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.service;

import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.queryparams.QueryParamsService;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.redis.RedisService;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiuLiConfigService {
    private static final String GET_CONFIG_PATH = "/liuli/logic/getConfigByClient";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiConfigService.class);
    private final LiuLiUtil liuLiUtil;
    private final RedisService redisService;
    private final ApplicationUtils applicationUtils;

    public LiuLiConfigService(LiuLiUtil liuLiUtil, RedisService redisService, ApplicationUtils applicationUtils) {
        this.liuLiUtil = liuLiUtil;
        this.redisService = redisService;
        this.applicationUtils = applicationUtils;
    }

    public JSONObject get(String configName) {
        String configRedisKey = "LiuLiConfigCache@" + configName;
        AtomicReference<JSONObject> config = new AtomicReference<JSONObject>((JSONObject)this.redisService.get(configRedisKey));
        if (config.get() == null) {
            this.redisService.lock(configRedisKey, () -> {
                config.set((JSONObject)this.redisService.get(configRedisKey));
                if (config.get() == null) {
                    String tenantUUID = (String)this.redisService.get("System@tenantUUID");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("tenantUUID", (Object)tenantUUID);
                    jsonObject.put("namespaceName", (Object)this.applicationUtils.getApplicationName());
                    jsonObject.put("environment", (Object)this.applicationUtils.getEnvType().getValue());
                    jsonObject.put("configName", (Object)configName);
                    String requestPath = this.liuLiUtil.getCloudUrl() + GET_CONFIG_PATH;
                    String cloudConfig = RestTools.post((String)requestPath, (JSONObject)jsonObject);
                    JSONObject result = new JSONObject(cloudConfig);
                    if (result.getInt("code") == 200) {
                        JSONObject data = result.getJSONObject("data");
                        JSONObject content = data.getJSONObject("content");
                        String type = data.getString("type");
                        if (type.equals("\u67e5\u8be2\u914d\u7f6e")) {
                            content = QueryParamsService.getQueryParamsInfo(content.toString());
                        }
                        this.redisService.set(configRedisKey, (Object)content);
                        config.set(content);
                    } else {
                        LOGGER.warn("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a" + result);
                        config.set(null);
                    }
                }
            });
        }
        return config.get();
    }

    public void removeCache(String configName) {
        String configRedisKey = "LiuLiConfigCache@" + configName;
        this.redisService.lock(configRedisKey, () -> this.redisService.delete(configRedisKey));
    }
}

