package com.af.v4.system.common.liuli.queryparams.enums;

import java.util.stream.Stream;

/**
 * 插槽类型
 *
 * @author Mr.river
 */
public enum SlotTypeEnum {
    //文本溢出省略
    ELLIPSIS("ellipsis"),
    //徽标
    BADGE("badge"),
    //日期格式化
    DATE("date"),
    //日期时间格式化
    DATE_TIME("dateTime"),
    //操作列
    ACTION("action");
    private final String value;

    SlotTypeEnum(String value) {
        this.value = value;
    }

    public static SlotTypeEnum toType(String value) {
        return Stream.of(SlotTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
