/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.service;

import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.redis.RedisService;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class LiuLiConfigService {
    private static final String GET_CONFIG_PATH = "/liuli/logic/getConfigByClient";
    private final LiuLiUtil liuLiUtil;
    private final RedisService redisService;
    private final ApplicationUtils applicationUtils;

    public LiuLiConfigService(LiuLiUtil liuLiUtil, RedisService redisService, ApplicationUtils applicationUtils) {
        this.liuLiUtil = liuLiUtil;
        this.redisService = redisService;
        this.applicationUtils = applicationUtils;
    }

    public JSONObject get(String configName) {
        String configRedisKey = "LiuLiConfigCache@" + configName;
        AtomicReference<JSONObject> config = new AtomicReference<JSONObject>((JSONObject)this.redisService.get(configRedisKey));
        if (config.get() == null) {
            this.redisService.lock(configRedisKey, () -> {
                config.set((JSONObject)this.redisService.get(configRedisKey));
                if (config.get() == null) {
                    String tenantUUID = (String)this.redisService.get("System@tenantUUID");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("tenantUUID", (Object)tenantUUID);
                    jsonObject.put("namespaceName", (Object)this.applicationUtils.getApplicationName());
                    jsonObject.put("environment", (Object)this.applicationUtils.getEnvType().getValue());
                    jsonObject.put("configName", (Object)configName);
                    String requestPath = this.liuLiUtil.getCloudUrl() + GET_CONFIG_PATH;
                    String cloudConfig = RestTools.post((String)requestPath, (JSONObject)jsonObject);
                    JSONObject result = new JSONObject(cloudConfig);
                    if (result.getInt("code") == 200) {
                        JSONObject content = result.getJSONObject("data").getJSONObject("content");
                        this.redisService.set(configRedisKey, (Object)content);
                        config.set(content);
                    }
                    config.set(result);
                }
            });
        }
        return config.get();
    }

    public void removeCache(String configName) {
        String configRedisKey = "LiuLiConfigCache@" + configName;
        this.redisService.lock(configRedisKey, () -> this.redisService.delete(configRedisKey));
    }
}

