package com.af.v4.system.common.liuli.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * 琉璃客户端配置
 *
 * @author Mr.river
 */
@Configuration
@ConfigurationProperties(prefix = "liuli")
@Component
public class LiuLiClientConfig {
    /**
     * 运行模式
     */
    private LiuLiClientOperationalModeEnum liuLiClientOperationalMode;
    /**
     * 琉璃中心服务地址
     */
    private String serverUrl;
    /**
     * 心跳开关
     */
    private Boolean heartbeat;
    /**
     * 上报错误日志开关
     */
    private Boolean uploadErrorLog;

    public String getServerUrl() {
        if (serverUrl == null) {
            serverUrl = "http://aote-office.8866.org:31467/api";
        }
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public Boolean getHeartbeat() {
        if (heartbeat == null) {
            heartbeat = true;
        }
        return heartbeat;
    }

    public void setHeartbeat(Boolean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public Boolean getUploadErrorLog() {
        if (uploadErrorLog == null) {
            uploadErrorLog = true;
        }
        return uploadErrorLog;
    }

    public void setUploadErrorLog(Boolean uploadErrorLog) {
        this.uploadErrorLog = uploadErrorLog;
    }

    public LiuLiClientOperationalModeEnum getLiuLiClientOperationalMode() {
        if (liuLiClientOperationalMode == null) {
            liuLiClientOperationalMode = LiuLiClientOperationalModeEnum.NORMAL;
        }
        return liuLiClientOperationalMode;
    }

    public void setLiuLiClientOperationalMode(String liuLiClientOperationalMode) {
        this.liuLiClientOperationalMode = LiuLiClientOperationalModeEnum.toType(liuLiClientOperationalMode);
        if (this.liuLiClientOperationalMode == null) {
            throw new ServiceException("琉璃客户端运行模式错误：" + liuLiClientOperationalMode);
        }
    }
}
