/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.simpleform;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.AddOrEditTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.SilencePurposeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.utils.FormBuildUtil;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SimpleFormConfigParser
extends ConfigParser {
    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.SIMPLE_FORM;
    }

    @Override
    public JSONObject parse(JSONObject config) {
        String groupName = config.optString("group", null);
        String describe = config.optString("describe", null);
        JSONArray queryColumnArray = config.getJSONArray("column");
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        String xAddFormLayout = config.optString("xAddFormLayout", "horizontal");
        boolean isKeyHandle = config.optBoolean("isKeyHandle", true);
        for (Object columnItem : queryColumnArray) {
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            FormTypeEnum formTypeEnum = FormBuildUtil.getFormType(column, key);
            JSONObject item = new JSONObject();
            item.put("model", (Object)key.replace('.', '_'));
            item.put("type", (Object)formTypeEnum.getValue());
            item.put("name", (Object)column.getString("title"));
            item.put("formDefault", column.opt("formDefault"));
            item.put("dataChangeFunc", column.opt("dataChangeFunc"));
            item.put("showFormItemFunc", column.opt("showFormItemFunc"));
            FormBuildUtil.buildFileRes(column, formTypeEnum, item);
            FormBuildUtil.buildDataSource(column, formTypeEnum, item);
            FormBuildUtil.buildRuleAndPlaceholder(column, key, item);
            item.put("addOrEdit", (Object)column.optString("addOrEdit", "all"));
            item.put("isOnlyAddOrEdit", true);
            if (Objects.equals(column.optString("addOrEdit", "all"), AddOrEditTypeEnum.SILENCE_ADD.getValue())) {
                if (column.has("silencePurpose")) {
                    String silencePurpose = column.getString("silencePurpose");
                    SilencePurposeEnum silencePurposeEnum = SilencePurposeEnum.toType(silencePurpose);
                    if (silencePurposeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u6307\u5b9a\u7684\u5b57\u6bb5\u7528\u9014\u4e0d\u5b58\u5728\uff1a" + silencePurpose, Integer.valueOf(400));
                    }
                    if (silencePurposeEnum == SilencePurposeEnum.CUSTOMIZE) {
                        if (column.has("silenceSource")) {
                            item.put("silenceSource", (Object)column.getString("silenceSource"));
                        } else {
                            throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5\u7528\u9014\u5fc5\u987b\u6307\u5b9a\u4e1a\u52a1\u903b\u8f91\u540d\u79f0(silenceSource)", Integer.valueOf(400));
                        }
                    }
                    item.put("silencePurpose", (Object)column.getString("silencePurpose"));
                } else {
                    throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u7528\u9014", Integer.valueOf(400));
                }
            }
            formItemArray.put((Object)item);
        }
        JSONObject columnResult = new JSONObject();
        columnResult.put("formJson", (Object)formItemArray);
        columnResult.put("groupName", (Object)groupName);
        columnResult.put("describe", (Object)describe);
        columnResult.put("xAddFormLayout", (Object)xAddFormLayout);
        columnResult.put("isKeyHandle", isKeyHandle);
        return columnResult;
    }
}

