package com.af.v4.system.common.liuli.config.parser.simpleform;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.AddOrEditTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.SilencePurposeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.utils.FormBuildUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 简单表单配置解析器
 * <p>
 * 详见 /docs/config/queryConfig/简单表单配置介绍.md
 *
 * @author Mr.river
 */
@Component
public class SimpleFormConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.SIMPLE_FORM;
    }

    /**
     * 根据配置文件生成简单表单
     */
    public JSONObject parse(JSONObject config) {
        // 组名
        String groupName = config.optString("group", null);
        // 组描述
        String describe = config.optString("describe", null);
        // 配置文件的数据列集合
        JSONArray queryColumnArray = config.getJSONArray("column");
        // 组织生成的表单项集合
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        // 新增修改表单项排序方式
        String xAddFormLayout = config.optString("xAddFormLayout","horizontal");
        // 是否处理key c_f_userinfo_id -> f_userinfo_id
        boolean isKeyHandle = config.optBoolean("isKeyHandle",true);
        // 遍历数据列集合
        for (Object columnItem : queryColumnArray) {
            JSONObject column = (JSONObject) columnItem;
            // 获取该列的字段
            String key = column.getString("key");
            // 获取该列的表单类型
            FormTypeEnum formTypeEnum = FormBuildUtil.getFormType(column, key);
            // 组织表单项
            JSONObject item = new JSONObject();
            item.put("model", key.replace('.', '_'));
            item.put("type", formTypeEnum.getValue());
            item.put("name", column.getString("title"));
            item.put("formDefault", column.opt("formDefault"));
            item.put("dataChangeFunc", column.opt("dataChangeFunc"));
            item.put("showFormItemFunc", column.opt("showFormItemFunc"));
            FormBuildUtil.buildFileRes(column, formTypeEnum, item);
            FormBuildUtil.buildDataSource(column, formTypeEnum, item);
            FormBuildUtil.buildRuleAndPlaceholder(column, key, item);
            item.put("addOrEdit", column.optString("addOrEdit", "all"));
            item.put("isOnlyAddOrEdit", true);
            if (Objects.equals(column.optString("addOrEdit", "all"), AddOrEditTypeEnum.SILENCE_ADD.getValue())) {
                // 获取该列的字段用途
                SilencePurposeEnum silencePurposeEnum;
                if (column.has("silencePurpose")) {
                    String silencePurpose = column.getString("silencePurpose");
                    silencePurposeEnum = SilencePurposeEnum.toType(silencePurpose);
                    if (silencePurposeEnum == null) {
                        throw new ServiceException("列[" + key + "]无法生成表单项，因为这个静默新增场景指定的字段用途不存在：" + silencePurpose, HttpStatus.BAD_REQUEST);
                    } else if (silencePurposeEnum == SilencePurposeEnum.CUSTOMIZE) {
                        // 如果是自定义用途，需要获取Logic名称
                        if (column.has("silenceSource")) {
                            item.put("silenceSource", column.getString("silenceSource"));
                        } else {
                            throw new ServiceException("列[" + key + "]无法生成表单项，因为静默新增场景的自定义字段用途必须指定业务逻辑名称(silenceSource)", HttpStatus.BAD_REQUEST);
                        }
                    }
                    item.put("silencePurpose", column.getString("silencePurpose"));
                } else {
                    throw new ServiceException("列[" + key + "]无法生成表单项，因为静默新增场景必须指定字段用途", HttpStatus.BAD_REQUEST);
                }
            }
            formItemArray.put(item);
        }
        JSONObject columnResult = new JSONObject();
        columnResult.put("formJson", formItemArray);
        columnResult.put("groupName", groupName);
        columnResult.put("describe", describe);
        columnResult.put("xAddFormLayout", xAddFormLayout);
        columnResult.put("isKeyHandle", isKeyHandle);
        return columnResult;
    }
}
