package com.af.v4.system.common.liuli.config.parser.curd.utils;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.RuleTypeEnum;
import org.json.JSONObject;

/**
 * 表单构建工具
 */
public class FormBuildUtil {
    /**
     * 构建表单校验和提示水印
     */
    public static void buildRuleAndPlaceholder(JSONObject column, String key, JSONObject item) {
        if (column.has("rule")) {
            JSONObject ruleObject = column.getJSONObject("rule");
            // 获取该列的表单校验类型
            RuleTypeEnum ruleTypeEnum;
            if (ruleObject.has("type")) {
                String ruleType = ruleObject.getString("type");
                ruleTypeEnum = RuleTypeEnum.toType(ruleType);
                if (ruleTypeEnum == null) {
                    throw new ServiceException("列[" + key + "]无法生成表单项，因为这个表单校验类型不存在：" + ruleType, HttpStatus.BAD_REQUEST);
                }
                if (ruleTypeEnum == RuleTypeEnum.STRLENGTH){
                    ruleObject.put("minLen", ruleObject.optNumber("minLen",0));
                    ruleObject.put("maxLen", ruleObject.optNumber("maxLen",0));
                    if (ruleObject.optInt("minLen",0) == 0 && ruleObject.optInt("maxLen",0) == 0){
                        throw new ServiceException("检验类型为字符串区间时，不能同时为 0 或者 最大长度不能为空", HttpStatus.BAD_REQUEST);
                    }
                }
                if (ruleTypeEnum == RuleTypeEnum.CUSTOM_JS){
                    if (!ruleObject.has("customValidatorFunc")){
                        throw new ServiceException("检验类型为自定义校验函数时，必须编写自定义函数 (customValidatorFunc)", HttpStatus.BAD_REQUEST);
                    }
                }
            } else {
                ruleObject.put("type", RuleTypeEnum.STRING.getValue());
            }
            item.put("rule", ruleObject);
        }
        if (column.has("placeholder")) {
            item.put("placeholder", column.getString("placeholder"));
        }
    }

    /**
     * 构建附件上传类表单
     */
    public static void buildFileRes(JSONObject column, FormTypeEnum formTypeEnum, JSONObject item) {
        if (formTypeEnum == FormTypeEnum.FILE || formTypeEnum == FormTypeEnum.IMAGE) {
            item.put("accept", column.getJSONArray("accept"));
            item.put("acceptCount", column.getInt("acceptCount"));
            item.put("resUploadMode", column.optString("resUploadMode", "server"));
            item.put("fileRootPath", column.getString("fileRootPath"));
            item.put("stockAlias", column.getString("stockAlias"));
            item.put("resUploadStock", column.getInt("resUploadStock"));
            item.put("pathKey", column.has("pathKey") ? column.getString("pathKey") : null);
            item.put("useType", column.has("useType") ? column.getString("useType") : null);
            item.put("uploadStyle", column.optString("uploadStyle"));
        }
        if (formTypeEnum == FormTypeEnum.INPUT) {
            // 表格插槽后缀名称/事件
            item.put("inputOnAfterName", column.optString("inputOnAfterName"));
            item.put("inputOnAfterFunc", column.optString("inputOnAfterFunc"));
            item.put("inputOnAfterIcon", column.optString("inputOnAfterIcon"));
            item.put("inputOnAfterIconFunc", column.optString("inputOnAfterIconFunc"));
            item.put("inputOnBlurFunc", column.optString("inputOnBlurFunc"));
            item.put("defaultFocus", column.optBoolean("defaultFocus"));
            item.put("occupyCol", column.optInt("occupyCol",1));
        }
        if (formTypeEnum == FormTypeEnum.ADDRESS_SEARCH) {
            // 表格插槽后缀名称/事件
            item.put("inputOnAfterName", column.optString("inputOnAfterName"));
            item.put("inputOnAfterFunc", column.optString("inputOnAfterFunc"));
            // 表格插槽后缀名称/事件
            item.put("occupyCol", column.optInt("occupyCol",1));
        }
        if (formTypeEnum == FormTypeEnum.CITY_SELECT) {
            item.put("contexts", column.optInt("contexts",4));
            item.put("valueType", column.optString("valueType","address"));
        }
    }

    /**
     * 获取表单类型
     */
    public static FormTypeEnum getFormType(JSONObject column, String key) {
        FormTypeEnum formTypeEnum;
        if (column.has("formType")) {
            String formType = column.getString("formType");
            formTypeEnum = FormTypeEnum.toType(formType);
            if (formTypeEnum == null) {
                throw new ServiceException("列[" + key + "]无法生成表单项，因为这个表单类型不存在：" + formType, HttpStatus.BAD_REQUEST);
            }
        } else {
            formTypeEnum = FormTypeEnum.INPUT;
        }
        return formTypeEnum;
    }

}
