package com.af.v4.system.common.liuli.config.parser.curd.enums;

import java.util.stream.Stream;

/**
 * 表单校验类型
 *
 * @author Mr.river
 */
public enum RuleTypeEnum {
    //字符串
    STRING("string"),
    //数字
    NUMBER("number"),
    //布尔值
    BOOLEAN("boolean"),
    //正则表达式
    REGEXP("regexp"),
    //整数
    INTEGER("integer"),
    //小数
    FLOAT("float"),
    //数组或集合
    ARRAY("array"),
    //日期
    DATE("date"),
    //邮箱
    EMAIL("email"),
    //身份证号
    IDNUMBER("idNumber"),
    //手机号码
    USERPHONE("userPhone"),
    //座机号码
    LANDLINENUMBER("landlineNumber"),
    //大于0
    GREATERTHANZERO("greaterThanZero"),
    //大于等于0
    GREATERTHANOREQUALZERO("greaterThanOrEqualZero"),
    //字符串长度限制
    STRLENGTH("stringLength"),
    //自定义校验函数
    CUSTOM_JS("customJs");

    private final String value;

    RuleTypeEnum(String value) {
        this.value = value;
    }

    public static RuleTypeEnum toType(String value) {
        return Stream.of(RuleTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
