/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.curd.utils;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.RuleTypeEnum;
import org.json.JSONObject;

public class FormBuildUtil {
    public static void buildRuleAndPlaceholder(JSONObject column, String key, JSONObject item) {
        if (column.has("rule")) {
            JSONObject ruleObject = column.getJSONObject("rule");
            if (ruleObject.has("type")) {
                String ruleType = ruleObject.getString("type");
                RuleTypeEnum ruleTypeEnum = RuleTypeEnum.toType(ruleType);
                if (ruleTypeEnum == null) {
                    throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u6821\u9a8c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + ruleType, Integer.valueOf(400));
                }
                if (ruleTypeEnum == RuleTypeEnum.STRLENGTH) {
                    ruleObject.put("minLen", (Object)ruleObject.optNumber("minLen", (Number)0));
                    ruleObject.put("maxLen", (Object)ruleObject.optNumber("maxLen", (Number)0));
                    if (ruleObject.optInt("minLen", 0) == 0 && ruleObject.optInt("maxLen", 0) == 0) {
                        throw new ServiceException("\u68c0\u9a8c\u7c7b\u578b\u4e3a\u5b57\u7b26\u4e32\u533a\u95f4\u65f6\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a 0 \u6216\u8005 \u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", Integer.valueOf(400));
                    }
                }
                if (ruleTypeEnum == RuleTypeEnum.CUSTOM_JS && !ruleObject.has("customValidatorFunc")) {
                    throw new ServiceException("\u68c0\u9a8c\u7c7b\u578b\u4e3a\u81ea\u5b9a\u4e49\u6821\u9a8c\u51fd\u6570\u65f6\uff0c\u5fc5\u987b\u7f16\u5199\u81ea\u5b9a\u4e49\u51fd\u6570 (customValidatorFunc)", Integer.valueOf(400));
                }
            } else {
                ruleObject.put("type", (Object)RuleTypeEnum.STRING.getValue());
            }
            item.put("rule", (Object)ruleObject);
        }
        if (column.has("placeholder")) {
            item.put("placeholder", (Object)column.getString("placeholder"));
        }
    }

    public static void buildFileRes(JSONObject column, FormTypeEnum formTypeEnum, JSONObject item) {
        if (formTypeEnum == FormTypeEnum.FILE || formTypeEnum == FormTypeEnum.IMAGE) {
            item.put("accept", (Object)column.getJSONArray("accept"));
            item.put("acceptCount", column.getInt("acceptCount"));
            item.put("resUploadMode", (Object)column.optString("resUploadMode", "server"));
            item.put("fileRootPath", (Object)column.getString("fileRootPath"));
            item.put("stockAlias", (Object)column.getString("stockAlias"));
            item.put("resUploadStock", column.getInt("resUploadStock"));
            item.put("pathKey", column.has("pathKey") ? column.getString("pathKey") : null);
            item.put("useType", column.has("useType") ? column.getString("useType") : null);
            item.put("uploadStyle", (Object)column.optString("uploadStyle"));
        }
        if (formTypeEnum == FormTypeEnum.INPUT) {
            item.put("inputOnAfterName", (Object)column.optString("inputOnAfterName"));
            item.put("inputOnAfterFunc", (Object)column.optString("inputOnAfterFunc"));
            item.put("inputOnAfterIcon", (Object)column.optString("inputOnAfterIcon"));
            item.put("inputOnAfterIconFunc", (Object)column.optString("inputOnAfterIconFunc"));
            item.put("inputOnBlurFunc", (Object)column.optString("inputOnBlurFunc"));
            item.put("defaultFocus", column.optBoolean("defaultFocus"));
            item.put("occupyCol", column.optInt("occupyCol", 1));
        }
        if (formTypeEnum == FormTypeEnum.ADDRESS_SEARCH) {
            item.put("inputOnAfterName", (Object)column.optString("inputOnAfterName"));
            item.put("inputOnAfterFunc", (Object)column.optString("inputOnAfterFunc"));
            item.put("occupyCol", column.optInt("occupyCol", 1));
        }
        if (formTypeEnum == FormTypeEnum.CITY_SELECT) {
            item.put("contexts", column.optInt("contexts", 4));
            item.put("valueType", (Object)column.optString("valueType", "address"));
        }
    }

    public static FormTypeEnum getFormType(JSONObject column, String key) {
        FormTypeEnum formTypeEnum;
        if (column.has("formType")) {
            String formType = column.getString("formType");
            formTypeEnum = FormTypeEnum.toType(formType);
            if (formTypeEnum == null) {
                throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + formType, Integer.valueOf(400));
            }
        } else {
            formTypeEnum = FormTypeEnum.INPUT;
        }
        return formTypeEnum;
    }
}

