package com.af.v4.system.common.liuli.config.parser.simpleformgroup;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.simpleform.SimpleFormConfigParser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * 表单组配置解析器
 *
 * <p>
 *  不再使用前端循环解析表单组，而是使用后端解析表单组，让表单可以统一渲染
 * </p>
 *
 * 作者: 张振宇
 */
@Component
public class SimpleFormGroupConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.SIMPLE_FORM_GROUP;
    }

    /**
     * 解析表单组配置
     *
     * @param config JSON 配置对象
     * @return 解析后的 JSON 对象
     */
    @Override
    public JSONObject parse(final JSONObject config) {
        // 取出表单组数据
        final JSONArray groups = config.optJSONArray("groups");

        // 如果 groups 为空，直接返回
        if (groups == null) {
            return new JSONObject().put("groups", new JSONArray());
        }

        // 初始化结果对象
        final JSONObject result = new JSONObject().put("groups", new JSONArray());
        // 定义简易变单组解析器
        final SimpleFormConfigParser simpleFormConfigParser = SpringUtils.getBean(SimpleFormConfigParser.class);

        // 循环进行简易变单组解析
        for (int i = 0; i < groups.length(); i++) {
            final JSONObject group = groups.getJSONObject(i);
            final JSONObject groupResult = parseGroup(group, simpleFormConfigParser);
            result.getJSONArray("groups").put(groupResult);
        }

        return result;
    }

    /**
     * 解析单个表单组
     *
     * @param group 单个表单组的 JSON 对象
     * @param simpleFormConfigParser 简易表单解析器
     * @return 解析后的 JSON 对象
     */
    private JSONObject parseGroup(final JSONObject group, final SimpleFormConfigParser simpleFormConfigParser) {
        if ("slot".equals(group.optString("formGroupType"))) {
            return group;
        } else {
            return simpleFormConfigParser.parse(group);
        }
    }
}
