package com.af.v4.system.common.liuli.config.parser.report;

import com.af.v4.system.common.expression.report.core.Report;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * REPORT解析实现
 * <p>
 * 适用于REPORT业务
 */
@Component
public class ReportConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.REPORT;
    }

    @Override
    public JSONObject parse(JSONObject source) {
        if (source.has("source")) {
            String sourceContent = source.getString("source");
            Report report = new Report(sourceContent, new JSONObject());
            report.compile();
        }
        return source;
    }
}
