package com.af.v4.system.common.liuli.config.parser.curd.enums;

import java.util.stream.Stream;

/**
 * @Classname AggregateFunctionTypeEnum
 * @Description TODO 聚合函数类型
 * @Date 2024/7/30 下午4:23
 * @Created by 张振宇
 */
public enum AggregateFunctionTypeEnum {
    SUM("sum"),
    MAX("max"),
    MIN("min"),
    AVG("avg"),
    COUNT("count");

    private final String value;

    AggregateFunctionTypeEnum(String value) {
        this.value = value;
    }

    public static AggregateFunctionTypeEnum toType(String value) {
        return Stream.of(AggregateFunctionTypeEnum.values())
                .filter(p -> p.value.equalsIgnoreCase(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}