package com.af.v4.system.common.liuli.config.parser.curd.entity;

import org.json.JSONArray;

/**
 * 数据模式
 *
 * @param queryForm         渲染查询表单项
 * @param table             渲染表格列
 * @param addOrEditForm     渲染新增/修改表单项
 * @param sqlQueryItem      SQL生成查询项
 * @param sqlQueryCondition SQL生成查询表达式
 * @param excelImportItem   excel导入项
 * @param group             字段组
 * @author Mr.river
 */
public record DataMode(boolean queryForm, boolean table, boolean addOrEditForm, boolean sqlQueryItem,
                       boolean sqlQueryCondition, boolean excelImportItem, boolean group, boolean tableSummary) {

    private static final DataMode DEFAULT_VALUE = new DataMode(true, true, true, true,
            true, false, false, false);

    public static DataMode getDefaultValue() {
        return DEFAULT_VALUE;
    }

    /**
     * 获取数据模式
     *
     * @param dataModeArray 数据模式集合
     * @return 数据模式
     */
    public static DataMode getDataMode(JSONArray dataModeArray) {
        boolean queryForm = false;
        boolean table = false;
        boolean addOrEditForm = false;
        boolean sqlQueryItem = false;
        boolean sqlQueryCondition = false;
        boolean excelImportItem = false;
        boolean tableSummary = false;
        boolean group = false;
        for (Object item : dataModeArray) {
            switch ((String) item) {
                case "queryForm" -> queryForm = true;
                case "table" -> table = true;
                case "addOrEditForm" -> addOrEditForm = true;
                case "sqlQueryItem" -> sqlQueryItem = true;
                case "sqlQueryCondition" -> sqlQueryCondition = true;
                case "excelImportItem" -> excelImportItem = true;
                case "group" -> group = true;
                case "tableSummary" -> tableSummary = true;
                default -> {
                }
            }
        }
        return new DataMode(queryForm, table, addOrEditForm, sqlQueryItem, sqlQueryCondition, excelImportItem, group, tableSummary);
    }
}
