package com.af.v4.system.common.liuli.utils;

import com.af.v4.system.common.core.constant.CacheConstants;
import com.af.v4.system.common.redis.RedisService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 琉璃工具类
 *
 * @author Mr.river
 */
@Component
public class LiuLiUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiUtil.class);

    /**
     * 琉璃服务端地址-RedisKey
     */
    private static final String CLOUD_URL_KEY = CacheConstants.CONFIG_DATA_CACHE_KEY + "CloudUrl";
    /**
     * 默认琉璃端服务地址
     */
    private static final String DEFAULT_CLOUD_URL = "http://aote-office.8866.org:31467/api";


    private final RedisService redisService;

    public LiuLiUtil(RedisService redisService) {
        this.redisService = redisService;
    }

    /**
     * 获取琉璃服务端地址
     * 返回值：琉璃配置中心路径
     */
    public String getCloudUrl() {
        return DEFAULT_CLOUD_URL;
    }

    /**
     * 更新琉璃服务端地址
     *
     * @param cloudUrl 接口地址
     */
    public void updateCloudUrl(String cloudUrl) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cloudUrl", cloudUrl);
        redisService.syncLock(CLOUD_URL_KEY, () -> {
            redisService.set(CLOUD_URL_KEY, jsonObject);
            return null;
        });
    }
}
