package com.af.v4.system.common.liuli.utils;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import org.json.JSONObject;

/**
 * 琉璃配置解析
 */
public class ConfigParserUtils {
    /**
     * 解析配置
     *
     * @param configType 配置类型
     * @param content    配置内容
     * @return 解析后配置
     */
    public static JSONObject parse(String configType, JSONObject content) {
        return ConfigParser.build(LiuLiConfigTypeEnum.toType(configType)).parse(content);
    }
}
