/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.utils;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.enums.CompatibleVersion;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.security.utils.SecurityUtils;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public final class ApplicationUtils {
    private static final String SYSTEM_V4_VERSION;
    private static final String APP_VERSION;
    private static final OSTypeEnum OS_TYPE;
    private String DEFAULT_TENANT_NAME = null;
    private EnvType ENV_TYPE = null;
    private String APPLICATION_NAME = null;
    private CompatibleVersion COMPATIBLE_VERSION = null;

    public static String getSystemV4Version() {
        return SYSTEM_V4_VERSION;
    }

    public static DbType getDbType() {
        return DynamicDataSource.getDbType();
    }

    public static OSTypeEnum getOSType() {
        return OS_TYPE;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public EnvType getEnvType() {
        return this.ENV_TYPE;
    }

    @Value(value="${spring.profiles.active}")
    public void setEnvType(String envType) {
        this.ENV_TYPE = EnvType.toType((String)envType);
        if (this.ENV_TYPE == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u8fd0\u884c\u73af\u5883\u7c7b\u578b[" + envType + "]", Integer.valueOf(506));
        }
    }

    public String getEnvTypeValue() {
        return this.ENV_TYPE.getValue();
    }

    public String getApplicationName() {
        return this.APPLICATION_NAME;
    }

    @Value(value="${spring.application.name}")
    public void setApplicationName(String applicationName) {
        this.APPLICATION_NAME = applicationName;
    }

    public String getTenantName() {
        String userTenantName;
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser != null && (userTenantName = loginUser.getTenantName()) != null) {
            return userTenantName;
        }
        return this.DEFAULT_TENANT_NAME;
    }

    @Value(value="${tenant.name}")
    public void setTenantName(String tenantName) {
        this.DEFAULT_TENANT_NAME = tenantName;
    }

    public CompatibleVersion getCompatibleVersion() {
        return this.COMPATIBLE_VERSION;
    }

    @Value(value="${tenant.version}")
    public void setCompatibleVersion(String version) {
        this.COMPATIBLE_VERSION = CompatibleVersion.toType((String)version);
    }

    public JSONObject getValues() {
        return new JSONObject().put("tenantName", (Object)this.getTenantName()).put("envType", (Object)this.getEnvTypeValue()).put("applicationName", (Object)this.getApplicationName()).put("compatibleVersion", (Object)this.COMPATIBLE_VERSION.getValue()).put("appVersion", (Object)ApplicationUtils.getAppVersion()).put("dbType", (Object)ApplicationUtils.getDbType().name()).put("osType", (Object)ApplicationUtils.getOSType().getValue()).put("systemV4Version", (Object)ApplicationUtils.getSystemV4Version());
    }

    static {
        String appVersion;
        SYSTEM_V4_VERSION = ApplicationUtils.class.getPackage().getImplementationVersion();
        ClassLoader cl = ApplicationUtils.class.getClassLoader();
        URL url = cl.getResource("META-INF/MANIFEST.MF");
        if (url != null) {
            try {
                Manifest manifest = new Manifest(url.openStream());
                Attributes mainAttributes = manifest.getMainAttributes();
                appVersion = mainAttributes.getValue("Implementation-Version");
            }
            catch (IOException e) {
                appVersion = "0";
            }
        } else {
            appVersion = "0";
        }
        APP_VERSION = appVersion;
        String osName = System.getProperty("os.name").toLowerCase();
        OS_TYPE = osName.contains("linux") ? OSTypeEnum.LINUX : OSTypeEnum.WINDOWS;
    }
}

