package com.af.v4.system.common.liuli.config.parser.xml;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.StringReader;

/**
 * XML配置解析实现
 * <p>
 * 适用于普通XML配置
 */
@Component
public class XMLConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.XML;
    }

    @Override
    public JSONObject parse(JSONObject source) {
        SAXReader xmlReader = new SAXReader();
        try {
            xmlReader.read(new StringReader(source.getString("source")));
        } catch (DocumentException e) {
            String message = e.getMessage();
            throw new ServiceException("编译错误，" + message, HttpStatus.BAD_REQUEST);
        }
        return source;
    }
}
