/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.service;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.LRUCache;
import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.redis.RedisService;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiuLiConfigService {
    public static final String NAMESPACE_CONFIGS_KEY = "_nameSpaceGroup_";
    private static final LRUCache<String, JSONObject> LIULI_CONFIG_LOCAL_CACHE = CacheUtil.newLRUCache((int)200);
    private static final String GET_CONFIG_PATH = "/af-liuli/logic/openapi/getConfigByClient";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiConfigService.class);
    private static EnvType envType = null;
    private final LiuLiUtil liuLiUtil;
    private final ApplicationUtils applicationUtils;
    private final RedisService redisService;
    private final DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory;

    public LiuLiConfigService(LiuLiUtil liuLiUtil, ApplicationUtils applicationUtils, RedisService redisService, DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory) {
        this.liuLiUtil = liuLiUtil;
        this.applicationUtils = applicationUtils;
        this.redisService = redisService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        envType = applicationUtils.getEnvType();
    }

    public static String getConfigCacheKey(String tenantName, String namespaceName, String environment, String configName) {
        return "LiuLiConfigCache@" + tenantName + "_" + namespaceName + "_" + environment + "_" + configName;
    }

    public static LRUCache<String, JSONObject> getLiuliConfigLocalCache() {
        return LIULI_CONFIG_LOCAL_CACHE;
    }

    public JSONObject get(String configName) {
        return this.get(configName, false);
    }

    public JSONObject getBySelf(String configName) {
        return this.get(configName, false, false);
    }

    public JSONObject getAll() {
        return this.getAll(false);
    }

    public JSONObject get(String configName, Boolean isThrowExceptionOnConfigNotFound, Boolean shouldGetConfigByParent) {
        if (configName == null) {
            LOGGER.error("\u914d\u7f6e\u540d\u4e0d\u80fd\u4e3anull");
            return null;
        }
        JSONObject configInfo = this.getConfigByCache(configName, key -> (JSONObject)this.redisService.lock(key, () -> this.getConfigByCache(configName, key2 -> this.getConfigByDatabase(configName, () -> this.getConfigByRequest(configName, shouldGetConfigByParent, result -> {
            if (!isThrowExceptionOnConfigNotFound.booleanValue()) {
                LOGGER.debug("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a{}", result);
                String tenantName = this.applicationUtils.getTenantName();
                String namespaceName = this.applicationUtils.getApplicationName();
                String environment = this.applicationUtils.getEnvType().getValue();
                this.addCache(tenantName, namespaceName, environment, configName, EmptyJSONObject.SELF);
                return null;
            }
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        }, true)))));
        return configInfo == null || configInfo instanceof EmptyJSONObject ? null : new JSONObject(configInfo.toString());
    }

    public JSONObject get(String configName, Boolean isThrowExceptionOnConfigNotFound) {
        return this.get(configName, isThrowExceptionOnConfigNotFound, true);
    }

    public JSONObject getAll(Boolean isThrowExceptionOnConfigNotFound) {
        JSONArray configs = this.get(NAMESPACE_CONFIGS_KEY, isThrowExceptionOnConfigNotFound, true).getJSONArray("value");
        JSONObject result = new JSONObject();
        configs.forEach(value -> {
            JSONObject valueObj = (JSONObject)value;
            result.put(valueObj.getString("name"), (Object)valueObj.getJSONObject("content"));
        });
        return result;
    }

    private JSONObject getConfigByCache(String configName, Function<String, JSONObject> notFoundFun) {
        String tenantName = this.applicationUtils.getTenantName();
        String namespaceName = this.applicationUtils.getApplicationName();
        String configCacheKey = LiuLiConfigService.getConfigCacheKey(tenantName, namespaceName, envType.getValue(), configName);
        JSONObject configContent = (JSONObject)LIULI_CONFIG_LOCAL_CACHE.get((Object)configCacheKey);
        if (envType != EnvType.DEV && configContent == null) {
            configContent = (JSONObject)this.redisService.get(configCacheKey);
            LOGGER.debug("\u901a\u8fc7redis\u83b7\u53d6\u7409\u7483\u914d\u7f6e[{}]\uff1a{}", (Object)configName, (Object)configContent);
            if (configContent != null) {
                LIULI_CONFIG_LOCAL_CACHE.put((Object)configCacheKey, (Object)configContent);
            }
        }
        return configContent != null ? configContent : notFoundFun.apply(configCacheKey);
    }

    private JSONObject getConfigByDatabase(String configName, Supplier<JSONObject> notFoundFun) {
        if (envType == EnvType.DEV) {
            return notFoundFun.get();
        }
        String tenantName = this.applicationUtils.getTenantName();
        String namespaceName = this.applicationUtils.getApplicationName();
        String environment = this.applicationUtils.getEnvType().getValue();
        JSONObject params = new JSONObject();
        params.put("tenantName", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            R result = remoteLogicService.run("getLiuLiConfig", params.toString(), "inner");
            if (result.getCode() == 200) {
                JSONObject response = result.parseResponseJson();
                LOGGER.debug("\u901a\u8fc7\u6570\u636e\u5e93\u83b7\u53d6\u7409\u7483\u914d\u7f6e[{}]\uff1a{}", (Object)configName, (Object)response);
                String contentStr = response.getJSONObject("data").optString("content", null);
                if (contentStr != null) {
                    JSONObject content = new JSONObject(contentStr);
                    this.addCache(tenantName, namespaceName, environment, configName, content);
                    return content;
                }
            } else {
                LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u51fa\u9519\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)result.getCode(), (Object)result.getMsg());
            }
        }
        catch (Throwable e) {
            LOGGER.error("af-system\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return notFoundFun.get();
    }

    private JSONObject getConfigByRequest(String configName, Boolean shouldGetConfigByParent, Function<R<JSONObject>, JSONObject> notFoundFun, Boolean isPrecompile) {
        String tenantName = this.applicationUtils.getTenantName();
        String namespaceName = this.applicationUtils.getApplicationName();
        String environment = this.applicationUtils.getEnvType().getValue();
        boolean hasConfigName = !Objects.equals(configName, NAMESPACE_CONFIGS_KEY);
        JSONObject params = new JSONObject();
        params.put("tenantUUID", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("shouldGetConfigByParent", (Object)shouldGetConfigByParent);
        if (hasConfigName) {
            params.put("configName", (Object)configName);
        }
        String requestPath = this.liuLiUtil.getCloudUrl() + GET_CONFIG_PATH;
        String cloudConfig = RestTools.post((String)requestPath, (JSONObject)params);
        LOGGER.debug("\u901a\u8fc7\u7409\u7483\u4e2d\u5fc3\u83b7\u53d6\u914d\u7f6e[{}]\uff1a{}", (Object)configName, (Object)cloudConfig);
        R result = R.build((JSONObject)new JSONObject(cloudConfig));
        if (result.getCode() == 200) {
            JSONObject data = (JSONObject)result.getData();
            JSONObject content = hasConfigName ? data.getJSONObject("content") : data;
            String module = data.optString("module", "null");
            String version = data.optString("version", "null");
            JSONObject tenant = data.optJSONObject("tenant");
            JSONObject namespace = data.optJSONObject("namespace");
            content.put("$globalProp", (Object)new JSONObject().put("module", (Object)module).put("environment", (Object)environment).put("version", (Object)version).put("namespaceName", (Object)(namespace != null ? namespace.getString("f_namespace_name") : "null")).put("tenantAlias", (Object)(tenant != null ? tenant.getString("f_tenant_uuid") : "null")));
            JSONObject configProp = hasConfigName ? data.optJSONObject("$configProp") : null;
            content.put("$configProp", (Object)(configProp != null ? configProp : new JSONObject()));
            if (isPrecompile.booleanValue() && hasConfigName) {
                LiuLiConfigTypeEnum type = LiuLiConfigTypeEnum.toType(data.getString("type"));
                content = ConfigParser.build(type).parse(content);
            }
            this.addCache(tenantName, namespaceName, environment, configName, content);
            this.addDatabase(tenantName, namespaceName, environment, configName, content);
            return content;
        }
        return notFoundFun.apply((R<JSONObject>)result);
    }

    public JSONObject getNativeConfigByRequest(String configName) {
        return this.getConfigByRequest(configName, true, result -> {
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        }, false);
    }

    private void addCache(String tenantName, String namespaceName, String environment, String configName, JSONObject content) {
        String configCacheKey = LiuLiConfigService.getConfigCacheKey(tenantName, namespaceName, environment, configName);
        LIULI_CONFIG_LOCAL_CACHE.put((Object)configCacheKey, (Object)content);
        if (envType != EnvType.DEV) {
            this.redisService.set(configCacheKey, (Object)content);
        }
    }

    private void addDatabase(String tenantName, String namespaceName, String environment, String configName, JSONObject content) {
        if (envType == EnvType.DEV) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("tenantName", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        params.put("configContent", (Object)content);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            remoteLogicService.run("addLiuLiConfig", params.toString(), "inner");
        }
        catch (Throwable e) {
            LOGGER.error("af-system\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public void removeCache(String namespaceName, String environment, String configName) {
        RTopic clientTopic = this.redisService.getTopic("Topic_LiuLi_ClearCache");
        clientTopic.publishAsync((Object)new JSONObject().put("namespaceName", (Object)namespaceName).put("environment", (Object)environment).put("configName", (Object)configName));
    }

    private static class EmptyJSONObject
    extends JSONObject {
        public static final EmptyJSONObject SELF = new EmptyJSONObject();

        private EmptyJSONObject() {
        }
    }
}

