package com.af.v4.system.common.liuli.config.parser.workflow;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.simpleform.SimpleFormConfigParser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.util.HashMap;

/**
 * 工作流配置解析器
 * <p>
 * 适用于工作流配置
 *
 * @author Mr.river
 */
@Component
public class WorkFlowConfigParser extends ConfigParser {

    private final SimpleFormConfigParser simpleFormConfigParser;

    public WorkFlowConfigParser(SimpleFormConfigParser simpleFormConfigParser) {
        this.simpleFormConfigParser = simpleFormConfigParser;
    }

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.WORK_FLOW;
    }

    /**
     * 根据配置文件生成工作流
     */
    public JSONObject parse(JSONObject config) {
        // 获取directions和steps的JSONArray
        JSONArray directions = config.getJSONArray("directions");
        JSONArray steps = config.getJSONArray("steps");

        // 使用HashMap优化查找过程
        HashMap<Integer, JSONObject> stepsMap = new HashMap<>();
        for (int i = 0; i < steps.length(); i++) {
            JSONObject step = steps.getJSONObject(i);
            stepsMap.put(step.getInt("id"), step);
        }

        // 遍历每一个direction，将其合并到对应的step中
        for (int i = 0; i < directions.length(); i++) {
            JSONObject direction = directions.getJSONObject(i);
            int head = direction.getInt("head");
            int tail = direction.getInt("tail");
            String type = direction.getString("type");

            // 创建新的action对象
            JSONObject action = new JSONObject();
            action.put("type", type);
            action.put("to", tail);

            // 直接使用HashMap查找对应的step
            JSONObject step = stepsMap.get(head);
            if (step != null) {
                JSONObject properties = step.getJSONObject("properties");
                // 解析formData
                if (properties.has("formData")) {
                    properties.put("form", simpleFormConfigParser.parse(properties.getJSONObject("formData")));
                    properties.remove("formData");
                }
                // 检查是否已经存在actions数组，如果不存在则创建
                if (!properties.has("actions")) {
                    properties.put("actions", new JSONArray());
                }
                properties.getJSONArray("actions").put(action);
            }
        }

        config.remove("directions");
        return config;
    }
}
