package com.af.v4.system.common.liuli.config.parser.logic;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * Logic解析实现
 * <p>
 * 适用于Logic业务
 */
@Component
public class LogicConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.LOGIC;
    }

    @Override
    public JSONObject parse(JSONObject source) {
        String sourceContent = source.getString("source");
        sourceContent = sourceContent.replace("\r\n", "\n");
        Program pros = new Program(sourceContent);
        // 解析
        try {
            pros.parse();
        } catch (RuntimeException e) {
            String message = e.getMessage();
            throw new ServiceException("编译错误，" + message, HttpStatus.BAD_REQUEST);
        }
        source.put("source", sourceContent);
        return source;
    }
}
