package com.af.v4.system.common.liuli.config.parser.dict;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * DICTIONARY配置解析实现
 * <p>
 * 适用于字典配置
 */
@Component
public class DictionaryConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.DICTIONARY;
    }

    @Override
    public JSONObject parse(JSONObject source) {
        if (!source.has("source")) {
            source.put("source", new JSONArray());
        }
        return source;
    }
}
