package com.af.v4.system.common.liuli.config.parser.curd.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

public class GetResUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetResUtil.class);

    public static int getTotalPages(Integer total, Integer pageSize) {
        return (int) Math.ceil((double) total / pageSize);
    }

    public static int getTotalPages(BigInteger total, Integer pageSize) {
        BigInteger result = total.divide(BigInteger.valueOf(pageSize)).add(total.mod(BigInteger.valueOf(pageSize)).compareTo(BigInteger.ZERO) > 0 ? BigInteger.ONE : BigInteger.ZERO);
        return result.intValue();
    }
}
