/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.curd;

import cn.hutool.core.lang.Tuple;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.entity.DataMode;
import com.af.v4.system.common.liuli.config.parser.curd.enums.AddOrEditTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.ColumnFixedTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.QueryTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.SilencePurposeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.SlotTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.utils.ConfigUtil;
import com.af.v4.system.common.liuli.config.parser.curd.utils.FormBuildUtil;
import com.af.v4.system.common.liuli.config.parser.curd.utils.SQLParserUtil;
import com.af.v4.system.common.plugins.json.JsonTools;
import com.alibaba.druid.DbType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CRUDFormConfigParser
extends ConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRUDFormConfigParser.class);

    private static String generateShortHashTableName(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            String hashText = no.toString(16);
            return "tbl" + hashText.substring(0, 8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.CRUD_FORM;
    }

    @Override
    public JSONObject parse(JSONObject config) {
        config = new JSONObject(config.toString().replace("&lt;", "<").replace("&gt;", ">"));
        StringBuilder sql = new StringBuilder("SELECT ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0) n");
        String mainTableName = ConfigUtil.parseKey(config.getString("tableName"));
        int mainTableNameSpiltIndex = mainTableName.indexOf(32);
        String mainTableMetaName = mainTableName.substring(0, mainTableNameSpiltIndex);
        String mainTableAliasName = mainTableName.substring(mainTableNameSpiltIndex + 1);
        JSONObject joinTableNameObject = config.getJSONObject("joinArray");
        for (String key : joinTableNameObject.keySet()) {
            joinTableNameObject.put(key, (Object)new JSONObject().put("value", (Object)ConfigUtil.parseKey(joinTableNameObject.getString(key))).put("type", (Object)"join"));
        }
        JSONObject buttonState = config.has("buttonState") ? config.getJSONObject("buttonState") : null;
        JSONObject apiSlot = config.has("apiSlot") ? config.getJSONObject("apiSlot") : null;
        JSONArray queryColumnArray = config.getJSONArray("column");
        JSONArray chineseQueryColumnArray = new JSONArray(queryColumnArray.length());
        JSONArray excelImportTemplate = new JSONArray();
        JSONArray canJoinTableNameArray = new JSONArray();
        JSONObject selectColumnObject = new JSONObject();
        JSONArray showColumnArray = new JSONArray(queryColumnArray.length());
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        for (Object columnItem : queryColumnArray) {
            String tableAlias;
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            String realKey = this.getRealKey(key);
            String columnAliasName = null;
            DataMode dataModeObject = column.has("dataModeArray") ? DataMode.getDataMode(column.getJSONArray("dataModeArray")) : DataMode.getDefaultValue();
            if (dataModeObject.sqlQueryItem()) {
                Tuple tuple = this.buildSQLQueryItem(key, realKey, column, sql, mainTableAliasName, joinTableNameObject, canJoinTableNameArray, chineseQueryColumnArray);
                key = (String)tuple.get(0);
                columnAliasName = (String)tuple.get(1);
            }
            if (dataModeObject.sqlQueryCondition()) {
                this.buildSqlQueryCondition(column, selectColumnObject, key);
            }
            if (dataModeObject.table()) {
                this.buildTableColumn(showColumnArray, column, columnAliasName, key, realKey, dataModeObject);
            }
            if (dataModeObject.queryForm() || dataModeObject.addOrEditForm()) {
                this.buildFormItem(column, key, dataModeObject, selectColumnObject, formItemArray, sql);
            }
            if (dataModeObject.excelImportItem() && (tableAlias = this.getTableAliasByColumn(key)).equals(mainTableAliasName)) {
                this.buildExcelImportItem(mainTableMetaName, column, realKey, excelImportTemplate);
            }
            if (!dataModeObject.group()) continue;
            this.buildGroup(dataModeObject, column, key, joinTableNameObject, showColumnArray, chineseQueryColumnArray, formItemArray, selectColumnObject, sql, mainTableAliasName, canJoinTableNameArray);
        }
        String orderBy = this.buildOrderBy(config, mainTableAliasName, joinTableNameObject, canJoinTableNameArray);
        String conditionStr = this.buildFixedQueryCondition(config, mainTableAliasName, joinTableNameObject, canJoinTableNameArray);
        sql.deleteCharAt(sql.length() - 1);
        sql.append("\n").append("FROM ").append(mainTableName);
        countSql.append("\n").append("FROM ").append(mainTableName);
        JSONObject result = new JSONObject();
        result.put("tableName", (Object)mainTableName);
        result.put("tableAliasName", (Object)mainTableAliasName);
        result.put("countSql", (Object)countSql.toString());
        result.put("querySql", (Object)sql.toString());
        result.put("joinTableNameObject", (Object)joinTableNameObject);
        result.put("canJoinTableNameArray", (Object)canJoinTableNameArray);
        result.put("selectColumn", (Object)selectColumnObject);
        result.put("orderBy", (Object)orderBy);
        result.put("condition", (Object)conditionStr);
        result.put("columnJson", (Object)showColumnArray);
        result.put("formJson", (Object)formItemArray);
        result.put("buttonState", (Object)buttonState);
        result.put("apiSlot", (Object)apiSlot);
        result.put("chineseQueryColumnArray", (Object)chineseQueryColumnArray);
        result.put("excelImportTemplate", (Object)excelImportTemplate);
        return result;
    }

    private String getRealKey(String key) {
        int index = key.indexOf(46);
        index = index == -1 ? 0 : ++index;
        return key.substring(index);
    }

    private String getTableAliasByColumn(String column) {
        int spiltIndex = column.indexOf(46);
        if (spiltIndex == -1) {
            throw new ServiceException("\u5217[" + column + "]\u6ca1\u6709\u914d\u7f6e\u8868\u522b\u540d\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", Integer.valueOf(400));
        }
        return column.substring(0, spiltIndex);
    }

    private Tuple buildSQLQueryItem(String key, String realKey, JSONObject column, StringBuilder sql, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray, JSONArray chineseQueryColumnArray) {
        String columnName;
        String queryKey;
        String columnAliasName;
        String tableAlias = this.getTableAliasByColumn(key);
        if (tableAlias.equals("$")) {
            int split = key.lastIndexOf(32);
            columnAliasName = "$_" + key.substring(split + 1);
            key = key.substring(0, split);
            queryKey = key.substring(2);
        } else {
            columnAliasName = tableAlias + "_" + realKey;
            queryKey = key;
        }
        queryKey = ConfigUtil.parseKey(queryKey);
        if (column.has("default")) {
            Object defaultValue = String.valueOf(column.get("default"));
            defaultValue = !((String)defaultValue).startsWith("$") ? "'" + (String)defaultValue + "'" : ((String)defaultValue).substring(1);
            DbType dbType = DynamicDataSource.getDbType();
            columnName = switch (dbType) {
                case DbType.sqlserver -> "ISNULL(" + queryKey + "," + (String)defaultValue + ") AS \"" + columnAliasName + "\"";
                case DbType.mysql -> "IFNULL(" + queryKey + "," + (String)defaultValue + ") AS \"" + columnAliasName + "\"";
                case DbType.oracle -> "NVL(" + queryKey + "," + (String)defaultValue + ") AS \"" + columnAliasName + "\"";
                default -> throw new ServiceException("\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\uff1a" + String.valueOf(dbType));
            };
        } else {
            columnName = queryKey + " AS \"" + columnAliasName + "\"";
        }
        sql.append("\n\t").append(columnName).append(",");
        SQLParserUtil.putJoinCondition(tableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, false);
        if (chineseQueryColumnArray != null) {
            chineseQueryColumnArray.put((Object)column.getString("title"));
        }
        return new Tuple(new Object[]{key, columnAliasName});
    }

    private void buildSqlQueryCondition(JSONObject column, JSONObject selectColumnObject, String key) {
        QueryTypeEnum queryTypeEnum;
        if (column.has("queryType")) {
            String queryType = column.getString("queryType");
            queryTypeEnum = QueryTypeEnum.toType(queryType);
            if (queryTypeEnum == null) {
                throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + queryType, Integer.valueOf(400));
            }
        } else {
            queryTypeEnum = QueryTypeEnum.EQUALS;
        }
        JSONObject selectColumnItem = new JSONObject();
        selectColumnItem.put("queryType", (Object)queryTypeEnum.getValue());
        selectColumnItem.put("key", (Object)key);
        selectColumnObject.put(key, (Object)selectColumnItem);
    }

    private void buildTableColumn(JSONArray showColumnArray, JSONObject column, String columnAliasName, String key, String realKey, DataMode dataModeObject) {
        JSONObject slot;
        JSONObject item = new JSONObject();
        item.put("title", (Object)column.getString("title"));
        item.put("dataIndex", (Object)(columnAliasName == null ? realKey : columnAliasName));
        item.put("sorter", dataModeObject.sqlQueryItem() && dataModeObject.sqlQueryCondition());
        int width = column.optInt("width", 0);
        if (!column.has("slot")) {
            slot = new JSONObject();
            slot.put("type", (Object)"ellipsis");
            slot.put("value", 16);
        } else {
            slot = column.getJSONObject("slot");
        }
        JSONObject scopedSlots = new JSONObject();
        scopedSlots.put("customRender", (Object)(columnAliasName == null ? realKey : columnAliasName));
        item.put("scopedSlots", (Object)scopedSlots);
        item.put("slots", (Object)scopedSlots);
        if (slot.has("type")) {
            String slotType = slot.getString("type");
            SlotTypeEnum slotTypeEnum = SlotTypeEnum.toType(slotType);
            if (slotTypeEnum == null) {
                throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u63d2\u69fd\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u63d2\u69fd\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + slotType, Integer.valueOf(400));
            }
            item.put("slotType", (Object)slotType);
            switch (slotTypeEnum) {
                case DATE_TIME: {
                    width = 160;
                    break;
                }
                case ELLIPSIS: {
                    int ellipsisValue = slot.getInt("value");
                    BigDecimal b = new BigDecimal(String.valueOf(ellipsisValue * 7 + 20 + 32));
                    if (width == 0) {
                        width = b.setScale(0, RoundingMode.UP).intValue();
                    }
                    item.put("slotValue", ellipsisValue);
                    break;
                }
                case BADGE: {
                    item.put("slotKeyMap", (Object)String.valueOf(slot.get("keyMap")));
                    width = 130;
                    break;
                }
                case ACTION: {
                    String actionText = slot.optString("actionText", "\u8be6\u60c5");
                    item.put("slotValue", (Object)actionText);
                }
            }
        } else {
            throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u63d2\u69fd\uff0c\u56e0\u4e3a\u6ca1\u6709\u6307\u5b9a\u63d2\u69fd\u7c7b\u578b\u53c2\u6570", Integer.valueOf(400));
        }
        if (width > 0) {
            item.put("width", width);
        }
        item.put("mobileColumnType", (Object)column.optString("mobileColumnType", "mobile_hide_column"));
        item.put("flexSpan", column.opt("flexSpan"));
        if (column.has("fixed")) {
            String fixedType = column.getString("fixed");
            ColumnFixedTypeEnum columnFixedTypeEnum = ColumnFixedTypeEnum.toType(fixedType);
            if (columnFixedTypeEnum == null) {
                throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u56fa\u5b9a\u5217\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u56fa\u5b9a\u5217\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + fixedType, Integer.valueOf(400));
            }
            item.put("fixed", (Object)fixedType);
        }
        showColumnArray.put((Object)item);
    }

    private void buildFormItem(JSONObject column, String key, DataMode dataModeObject, JSONObject selectColumnObject, JSONArray formItemArray, StringBuilder sql) {
        AddOrEditTypeEnum addOrEditTypeEnum;
        FormTypeEnum formTypeEnum = FormBuildUtil.getFormType(column, key);
        if (dataModeObject.addOrEditForm()) {
            if (column.has("addOrEdit")) {
                String addOrEditType = column.getString("addOrEdit");
                addOrEditTypeEnum = AddOrEditTypeEnum.toType(addOrEditType);
                if (addOrEditTypeEnum == null) {
                    throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u65b0\u589e/\u4fee\u6539\u573a\u666f\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + addOrEditType, Integer.valueOf(400));
                }
            } else {
                addOrEditTypeEnum = AddOrEditTypeEnum.ALL;
            }
        } else {
            addOrEditTypeEnum = AddOrEditTypeEnum.NO;
        }
        JSONObject item = new JSONObject();
        item.put("model", (Object)key.replaceFirst("\\.", "_"));
        item.put("type", (Object)formTypeEnum.getValue());
        item.put("queryType", (Object)column.optString("queryType", null));
        item.put("name", (Object)column.getString("title"));
        if (formTypeEnum == FormTypeEnum.SELECT || formTypeEnum == FormTypeEnum.CHECKBOX || formTypeEnum == FormTypeEnum.RADIO || formTypeEnum == FormTypeEnum.TREE_SELECT || formTypeEnum == FormTypeEnum.CASCADER) {
            if (column.has("selectKeyName")) {
                String selectKeyName = column.getString("selectKeyName");
                String tableAlias = selectKeyName.substring(0, selectKeyName.indexOf(46));
                int index = key.indexOf(46);
                index = index == -1 ? 0 : ++index;
                String realSelectKey = selectKeyName.substring(index);
                if (!selectKeyName.equals(key)) {
                    sql.append("\n\t").append(selectKeyName).append(" ").append(tableAlias).append("_").append(realSelectKey).append(",");
                    JSONObject selectColumnItem = new JSONObject();
                    selectColumnItem.put("queryType", (Object)column.optString("queryType", QueryTypeEnum.EQUALS.getValue()));
                    selectColumnItem.put("key", (Object)selectKeyName);
                    selectColumnObject.put(selectKeyName, (Object)selectColumnItem);
                    item.put("model", (Object)selectKeyName.replace('.', '_'));
                }
            }
            if (column.has("selectKey")) {
                Object selectKey = column.get("selectKey");
                if (selectKey instanceof JSONArray) {
                    item.put("keys", selectKey);
                } else {
                    item.put("keyName", selectKey);
                }
                if (column.has("lazyLoad")) {
                    item.put("lazyLoad", column.get("lazyLoad"));
                }
            }
        } else {
            FormBuildUtil.buildFileRes(column, formTypeEnum, item);
        }
        FormBuildUtil.buildRuleAndPlaceholder(column, key, item);
        item.put("addOrEdit", (Object)addOrEditTypeEnum.getValue());
        item.put("isOnlyAddOrEdit", !dataModeObject.queryForm());
        if (addOrEditTypeEnum == AddOrEditTypeEnum.SILENCE_ADD) {
            if (column.has("silencePurpose")) {
                String silencePurpose = column.getString("silencePurpose");
                SilencePurposeEnum silencePurposeEnum = SilencePurposeEnum.toType(silencePurpose);
                if (silencePurposeEnum == null) {
                    throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u6307\u5b9a\u7684\u5b57\u6bb5\u7528\u9014\u4e0d\u5b58\u5728\uff1a" + silencePurpose, Integer.valueOf(400));
                }
                if (silencePurposeEnum == SilencePurposeEnum.CUSTOMIZE) {
                    if (column.has("silenceSource")) {
                        item.put("silenceSource", (Object)column.getString("silenceSource"));
                    } else {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5\u7528\u9014\u5fc5\u987b\u6307\u5b9a\u4e1a\u52a1\u903b\u8f91\u540d\u79f0(silenceSource)", Integer.valueOf(400));
                    }
                }
                item.put("silencePurpose", (Object)column.getString("silencePurpose"));
            } else {
                throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u7528\u9014", Integer.valueOf(400));
            }
        }
        formItemArray.put((Object)item);
    }

    private void buildGroup(DataMode dataModeObject, JSONObject column, String key, JSONObject joinTableNameObject, JSONArray showColumnArray, JSONArray chineseQueryColumnArray, JSONArray formItemArray, JSONObject selectColumnObject, StringBuilder sql, String tableAliasName, JSONArray canJoinTableNameArray) {
        if (!dataModeObject.sqlQueryItem()) {
            return;
        }
        String innerTableAlias = CRUDFormConfigParser.generateShortHashTableName(key);
        JSONArray metaJsonArray = column.getJSONArray("column");
        JSONObject jsonTable = new JSONObject();
        jsonTable.put("column", (Object)metaJsonArray);
        jsonTable.put("tableName", (Object)(innerTableAlias + " " + innerTableAlias));
        jsonTable.put("joinArray", (Object)new JSONObject());
        ArrayList<Object> innerKeys = new ArrayList<Object>(metaJsonArray.length());
        for (Object item2 : metaJsonArray) {
            JSONObject jsonColumnItem = (JSONObject)item2;
            Object innerKey = jsonColumnItem.getString("key");
            innerKey = innerTableAlias + "." + (String)innerKey;
            jsonColumnItem.put("key", innerKey);
            innerKeys.add(innerKey);
        }
        StringBuilder jsonTableContent = new StringBuilder();
        DbType dbType = DynamicDataSource.getDbType();
        switch (dbType) {
            case sqlserver: {
                jsonTableContent.append("CROSS APPLY OPENJSON(ISNULL(").append(key).append(",'{}')) WITH(");
                innerKeys.forEach(item -> jsonTableContent.append("\n\t\t").append(this.getRealKey((String)item)).append(" ").append("varchar(100),"));
                jsonTableContent.deleteCharAt(jsonTableContent.length() - 1);
                jsonTableContent.append("\n\t) ").append(innerTableAlias);
                break;
            }
            case oracle: {
                jsonTableContent.append("CROSS JOIN JSON_TABLE(NVL(").append(key).append(",'{}'), '$' COLUMNS (");
                innerKeys.forEach(item -> {
                    String realKeyValue = this.getRealKey((String)item);
                    jsonTableContent.append("\n\t\t").append(realKeyValue).append(" ").append("varchar2(100) PATH '$.").append(realKeyValue).append("',");
                });
                jsonTableContent.deleteCharAt(jsonTableContent.length() - 1);
                jsonTableContent.append("\n\t)) ").append(innerTableAlias);
                break;
            }
            case mysql: {
                jsonTableContent.append("CROSS JOIN JSON_TABLE(IFNULL(").append(key).append(",'{}'), '$' COLUMNS (");
                innerKeys.forEach(item -> {
                    String realKeyValue = this.getRealKey((String)item);
                    jsonTableContent.append("\n\t\t").append(realKeyValue).append(" ").append("VARCHAR(100) PATH '$.").append(realKeyValue).append("',");
                });
                jsonTableContent.deleteCharAt(jsonTableContent.length() - 1);
                jsonTableContent.append("\n\t)) ").append(innerTableAlias);
                break;
            }
            default: {
                throw new ServiceException("\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\uff1a" + String.valueOf(dbType));
            }
        }
        joinTableNameObject.put(innerTableAlias, (Object)new JSONObject().put("value", (Object)jsonTableContent.toString()).put("type", (Object)"json"));
        JSONObject parseJsonColumns = this.parse(jsonTable);
        JSONArray jsonColumns = parseJsonColumns.getJSONArray("formJson");
        showColumnArray.putAll(parseJsonColumns.getJSONArray("columnJson"));
        chineseQueryColumnArray.putAll(parseJsonColumns.getJSONArray("chineseQueryColumnArray"));
        formItemArray.put((Object)new JSONObject().put("type", (Object)"group").put("name", (Object)column.getString("title")).put("groupItems", (Object)jsonColumns).put("model", (Object)key.replaceFirst("\\.", "_")));
        JsonTools.addJSON((JSONObject)selectColumnObject, (JSONObject)parseJsonColumns.getJSONObject("selectColumn"));
        for (Object item3 : metaJsonArray) {
            JSONObject jsonColumnItem = (JSONObject)item3;
            String innerKey = jsonColumnItem.getString("key");
            String innerRealKey = this.getRealKey(innerKey);
            this.buildSQLQueryItem(innerKey, innerRealKey, jsonColumnItem, sql, tableAliasName, joinTableNameObject, canJoinTableNameArray, null);
        }
    }

    private String buildOrderBy(JSONObject config, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray) {
        String orderBy = config.optString("orderBy", null);
        if (orderBy != null) {
            String tableAlias = orderBy.substring(0, orderBy.indexOf(46));
            SQLParserUtil.putJoinCondition(tableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, false);
        }
        return orderBy;
    }

    private String buildFixedQueryCondition(JSONObject config, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray) {
        String conditionStr;
        if (config.has("condition")) {
            JSONObject condition = config.getJSONObject("condition");
            conditionStr = condition.getString("value");
            if (condition.has("join")) {
                JSONArray joinArray = condition.getJSONArray("join");
                for (Object item : joinArray) {
                    String joinItem = item.toString();
                    SQLParserUtil.putJoinCondition(joinItem, tableAliasName, joinTableNameObject, canJoinTableNameArray, true);
                }
            }
        } else {
            conditionStr = "1=1";
        }
        return conditionStr;
    }

    private void buildExcelImportItem(String tableName, JSONObject column, String realKey, JSONArray excelImportTemplate) {
        JSONArray columnArray;
        JSONArray titleArray;
        JSONObject excelImportTemplateItem = null;
        for (Object item : excelImportTemplate) {
            JSONObject excelItem = (JSONObject)item;
            if (!excelItem.getString("tableName").equals(tableName)) continue;
            excelImportTemplateItem = excelItem;
            break;
        }
        if (excelImportTemplateItem == null) {
            excelImportTemplateItem = new JSONObject();
        }
        if (excelImportTemplateItem.has("title")) {
            titleArray = excelImportTemplateItem.getJSONArray("title");
            columnArray = excelImportTemplateItem.getJSONArray("column");
        } else {
            titleArray = new JSONArray();
            columnArray = new JSONArray();
            excelImportTemplateItem.put("tableName", (Object)tableName);
            excelImportTemplateItem.put("title", (Object)titleArray);
            excelImportTemplateItem.put("column", (Object)columnArray);
            excelImportTemplate.put((Object)excelImportTemplateItem);
        }
        titleArray.put((Object)column.getString("title"));
        columnArray.put((Object)realKey);
    }
}

