/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.workflow;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.simpleform.SimpleFormConfigParser;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowConfigParser
extends ConfigParser {
    private final SimpleFormConfigParser simpleFormConfigParser;

    public WorkFlowConfigParser(SimpleFormConfigParser simpleFormConfigParser) {
        this.simpleFormConfigParser = simpleFormConfigParser;
    }

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.WORK_FLOW;
    }

    @Override
    public JSONObject parse(JSONObject config) {
        int i;
        JSONArray directions = config.getJSONArray("directions");
        JSONArray steps = config.getJSONArray("steps");
        HashMap<Integer, JSONObject> stepsMap = new HashMap<Integer, JSONObject>();
        for (i = 0; i < steps.length(); ++i) {
            JSONObject step = steps.getJSONObject(i);
            stepsMap.put(step.getInt("id"), step);
        }
        for (i = 0; i < directions.length(); ++i) {
            JSONObject direction = directions.getJSONObject(i);
            int head = direction.getInt("head");
            int tail = direction.getInt("tail");
            String type = direction.getString("type");
            JSONObject action = new JSONObject();
            action.put("type", (Object)type);
            action.put("to", tail);
            JSONObject step = (JSONObject)stepsMap.get(head);
            if (step == null) continue;
            JSONObject properties = step.getJSONObject("properties");
            if (properties.has("formData")) {
                properties.put("form", (Object)this.simpleFormConfigParser.parse(properties.getJSONObject("formData")));
                properties.remove("formData");
            }
            if (!properties.has("actions")) {
                properties.put("actions", (Object)new JSONArray());
            }
            properties.getJSONArray("actions").put((Object)action);
        }
        config.remove("directions");
        return config;
    }
}

