package com.af.v4.system.common.liuli.config.parser.sql;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * SQL解析实现
 * <p>
 * 适用于SQL业务
 */
@Component
public class SQLConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.SQL;
    }

    @Override
    public JSONObject parse(JSONObject source) {
        String sourceContent = source.getString("source");
        // 获取编译后的sql语句
        sourceContent = sourceContent.replace("\r\n", "\n");
        sourceContent = "$" + sourceContent;
        //如果使用了新格式化参数写法，需要替换为解析语法树支持的写法
        if (sourceContent.contains("${")) {
            sourceContent = sourceContent.replace("${", "{");
        }
        source.put("source", sourceContent);
        return source;
    }
}
