/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.service;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.redis.RedisService;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiuLiConfigService {
    private static final String GET_CONFIG_PATH = "/af-liuli/logic/openapi/getConfigByClient";
    private static final String NAMESPACE_CONFIGS_KEY = "_nameSpaceGroup_";
    private static final Cache<String, JSONObject> LIULI_CONFIG_LOCAL_CACHE = CacheUtil.newLRUCache((int)100);
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiConfigService.class);
    private static EnvType envType = null;
    private final LiuLiUtil liuLiUtil;
    private final ApplicationUtils applicationUtils;
    private final RedisService redisService;
    private final DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory;

    public LiuLiConfigService(LiuLiUtil liuLiUtil, ApplicationUtils applicationUtils, RedisService redisService, DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory) {
        this.liuLiUtil = liuLiUtil;
        this.applicationUtils = applicationUtils;
        this.redisService = redisService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        envType = applicationUtils.getEnvType();
    }

    public JSONObject get(String configName) {
        return this.get(configName, false);
    }

    public JSONObject getBySelf(String configName) {
        return this.get(configName, false, false);
    }

    public JSONObject getAll() {
        return this.getAll(false);
    }

    public JSONObject get(String configName, Boolean isThrowExceptionOnConfigNotFound, Boolean shouldGetConfigByParent) {
        return this.getConfigByCache(configName, key -> (JSONObject)this.redisService.lock(key, () -> this.getConfigByCache(configName, key2 -> this.getConfigByDatabase(configName, () -> this.getConfigByRequest(configName, shouldGetConfigByParent, result -> {
            if (!isThrowExceptionOnConfigNotFound.booleanValue()) {
                LOGGER.warn("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a" + result);
                return null;
            }
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        }, true)))));
    }

    public JSONObject get(String configName, Boolean isThrowExceptionOnConfigNotFound) {
        return this.get(configName, isThrowExceptionOnConfigNotFound, true);
    }

    public JSONObject getAll(Boolean isThrowExceptionOnConfigNotFound) {
        JSONArray configs = this.get(NAMESPACE_CONFIGS_KEY, isThrowExceptionOnConfigNotFound, true).getJSONArray("value");
        JSONObject result = new JSONObject();
        configs.forEach(value -> {
            JSONObject valueObj = (JSONObject)value;
            result.put(valueObj.getString("name"), (Object)valueObj.getJSONObject("content"));
        });
        return result;
    }

    private JSONObject getConfigByCache(String configName, Function<String, JSONObject> notFoundFun) {
        String tenantName = this.applicationUtils.getTenantName();
        String namespaceName = this.applicationUtils.getApplicationName();
        String configCacheKey = this.getConfigCacheKey(tenantName, namespaceName, envType.getValue(), configName);
        JSONObject configContent = null;
        if (envType != EnvType.DEV && (configContent = (JSONObject)LIULI_CONFIG_LOCAL_CACHE.get((Object)configCacheKey)) == null) {
            configContent = (JSONObject)this.redisService.get(configCacheKey);
        }
        return configContent != null ? configContent : notFoundFun.apply(configCacheKey);
    }

    private JSONObject getConfigByDatabase(String configName, Supplier<JSONObject> notFoundFun) {
        if (envType == EnvType.DEV) {
            return notFoundFun.get();
        }
        String tenantName = this.applicationUtils.getTenantName();
        String namespaceName = this.applicationUtils.getApplicationName();
        String environment = this.applicationUtils.getEnvType().getValue();
        JSONObject params = new JSONObject();
        params.put("tenantName", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            R result = remoteLogicService.run("getLiuLiConfig", params.toString(), "inner");
            if (result.getCode() == 200) {
                String contentStr = result.parseResponseJson().getJSONObject("data").optString("content", null);
                if (contentStr != null) {
                    JSONObject content = new JSONObject(contentStr);
                    this.addCache(tenantName, namespaceName, environment, configName, content);
                    return content;
                }
            } else {
                LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u51fa\u9519\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)result.getCode(), (Object)result.getMsg());
            }
        }
        catch (Throwable e) {
            LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:" + e.getMessage());
        }
        return notFoundFun.get();
    }

    private JSONObject getConfigByRequest(String configName, Boolean shouldGetConfigByParent, Function<R<JSONObject>, JSONObject> notFoundFun, Boolean isPrecompile) {
        String requestPath;
        String cloudConfig;
        R result;
        String tenantUUID = this.applicationUtils.getTenantName();
        String namespaceName = this.applicationUtils.getApplicationName();
        String environment = this.applicationUtils.getEnvType().getValue();
        boolean hasConfigName = !Objects.equals(configName, NAMESPACE_CONFIGS_KEY);
        JSONObject params = new JSONObject();
        params.put("tenantUUID", (Object)tenantUUID);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("shouldGetConfigByParent", (Object)shouldGetConfigByParent);
        if (hasConfigName) {
            params.put("configName", (Object)configName);
        }
        if ((result = R.build((JSONObject)new JSONObject(cloudConfig = RestTools.post((String)(requestPath = this.liuLiUtil.getCloudUrl() + GET_CONFIG_PATH), (JSONObject)params)))).getCode() == 200) {
            JSONObject data = (JSONObject)result.getData();
            JSONObject content = hasConfigName ? data.getJSONObject("content") : data;
            String module = data.optString("module", null);
            content.put("$globalProp", (Object)new JSONObject().put("module", (Object)module));
            if (isPrecompile.booleanValue() && hasConfigName) {
                LiuLiConfigTypeEnum type = LiuLiConfigTypeEnum.toType(data.getString("type"));
                content = ConfigParser.build(type).parse(content);
                this.addCache(tenantUUID, namespaceName, environment, configName, content);
                this.addDatabase(tenantUUID, namespaceName, environment, configName, content);
            }
            return content;
        }
        return notFoundFun.apply((R<JSONObject>)result);
    }

    public JSONObject getNativeConfigByRequest(String configName) {
        return this.getConfigByRequest(configName, true, result -> {
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        }, false);
    }

    public void addCache(String tenantName, String namespaceName, String environment, String configName, JSONObject content) {
        if (envType == EnvType.DEV) {
            return;
        }
        String configCacheKey = this.getConfigCacheKey(tenantName, namespaceName, environment, configName);
        this.redisService.set(configCacheKey, (Object)content);
    }

    public void addDatabase(String tenantName, String namespaceName, String environment, String configName, JSONObject content) {
        if (envType == EnvType.DEV) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("tenantName", (Object)tenantName);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        params.put("configContent", (Object)content);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            remoteLogicService.run("addLiuLiConfig", params.toString(), "inner");
        }
        catch (Throwable e) {
            LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:" + e.getMessage());
        }
    }

    public void removeCache(String namespaceName, String environment, String configName) {
        String configCacheKey = this.getConfigCacheKey("*", namespaceName, environment, configName);
        this.redisService.lock(configCacheKey, () -> {
            this.redisService.delete(NAMESPACE_CONFIGS_KEY);
            this.redisService.deleteList(this.redisService.getKeys(configCacheKey));
        });
        LIULI_CONFIG_LOCAL_CACHE.remove((Object)configCacheKey);
    }

    private String getConfigCacheKey(String tenantName, String namespaceName, String environment, String configName) {
        return "LiuLiConfigCache@" + tenantName + "_" + namespaceName + "_" + environment + "_" + configName;
    }
}

