/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.monitor.service;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestAsyncTools;
import com.af.v4.system.common.plugins.http.core.response.EmptyAsyncResponse;
import com.af.v4.system.common.plugins.http.core.response.StandardAsyncResponse;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiuLiMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiMonitorService.class);
    private static final String UPLOAD_ERROR_LOG_PATH = "/liuli/logic/uploadErrorLog";
    private static final String SAVE_APPLICATION_INFO_PATH = "/liuli/logic/saveApplicationInfo";
    private static final String CHECK_V4_VERSION_PATH = "/liuli/logic/checkV4Version";
    private final ApplicationUtils applicationUtils;
    private final LiuLiUtil liuLiUtil;

    public LiuLiMonitorService(ApplicationUtils applicationUtils, LiuLiUtil liuLiUtil) {
        this.applicationUtils = applicationUtils;
        this.liuLiUtil = liuLiUtil;
    }

    public void uploadApplicationInfo() {
        String applicationName = this.applicationUtils.getApplicationName();
        if (applicationName.equals("af-liuli")) {
            return;
        }
        String requestPath = this.liuLiUtil.getCloudUrl() + SAVE_APPLICATION_INFO_PATH;
        JSONObject jsonObject = new JSONObject().put("tenantUUID", (Object)this.applicationUtils.getTenantName()).put("name", (Object)applicationName).put("coreVersion", (Object)this.getNowCoreVersion()).put("lastStartDate", (Object)DateTools.getNow2());
        RestAsyncTools.post((String)requestPath, (String)jsonObject.toString(), null, (FutureCallback)new StandardAsyncResponse(response -> {
            R result = R.build((JSONObject)new JSONObject(response));
            if (result.isSuccess().booleanValue()) {
                LOGGER.info("\u5e94\u7528\u4fe1\u606f\u4e0a\u4f20\u6210\u529f");
            } else {
                LOGGER.warn("\u5e94\u7528\u4fe1\u606f\u4e0a\u4f20\u5931\u8d25:{}", (Object)result.getMsg());
            }
        }, e -> LOGGER.error("\u68c0\u67e5SystemV4\u7248\u672c\u5931\u8d25:{}", (Object)e.getMessage())));
    }

    public void uploadLogicErrorLog(JSONObject operLog) {
        String requestPath = this.liuLiUtil.getCloudUrl() + UPLOAD_ERROR_LOG_PATH;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", (Object)this.applicationUtils.getTenantName());
        jsonObject.put("applicationName", (Object)this.applicationUtils.getApplicationName());
        jsonObject.put("environment", (Object)this.applicationUtils.getEnvType().getValue());
        jsonObject.put("method", operLog.opt("f_method"));
        jsonObject.put("requestMethod", operLog.opt("f_request_method"));
        jsonObject.put("operIp", operLog.opt("f_oper_ip"));
        jsonObject.put("operUrl", operLog.opt("f_oper_url"));
        jsonObject.put("operName", operLog.opt("f_oper_name"));
        jsonObject.put("operParam", operLog.opt("f_oper_param"));
        jsonObject.put("jsonResult", operLog.opt("f_json_result"));
        jsonObject.put("errorMsg", operLog.opt("f_error_msg"));
        jsonObject.put("businessTitle", operLog.opt("f_title"));
        jsonObject.put("businessType", operLog.opt("f_business_type"));
        jsonObject.put("operatorType", operLog.opt("f_operator_type"));
        jsonObject.put("costTime", operLog.opt("f_cost_time"));
        RestAsyncTools.post((String)requestPath, (String)jsonObject.toString(), null, (FutureCallback)new EmptyAsyncResponse());
    }

    public void checkV4Version() {
        String requestPath = this.liuLiUtil.getCloudUrl() + CHECK_V4_VERSION_PATH;
        RestAsyncTools.post((String)requestPath, (String)new JSONObject().put("version", (Object)this.getNowCoreVersion()).toString(), null, (FutureCallback)new StandardAsyncResponse(response -> {
            R result = R.build((JSONObject)new JSONObject(response));
            if (result.isSuccess().booleanValue()) {
                if (((JSONObject)result.getData()).getBoolean("hasUpdate")) {
                    LOGGER.warn(((JSONObject)result.getData()).getString("msg"));
                }
            } else {
                LOGGER.warn("\u68c0\u67e5SystemV4\u7248\u672c\u5931\u8d25:{}", (Object)result.getMsg());
            }
        }, e -> LOGGER.error("\u68c0\u67e5SystemV4\u7248\u672c\u5931\u8d25:{}", (Object)e.getMessage())));
    }

    private String getNowCoreVersion() {
        String nowVersion = LiuLiMonitorService.class.getPackage().getImplementationVersion();
        LOGGER.info("SystemV4 \u7248\u672c\uff1aV" + nowVersion);
        return nowVersion;
    }
}

