/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.simpleform;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.AddOrEditTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.utils.FormBuildUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SimpleFormConfigParser
extends ConfigParser {
    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.SIMPLE_FORM;
    }

    @Override
    public JSONObject parse(JSONObject config) {
        JSONArray queryColumnArray = config.getJSONArray("column");
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        for (Object columnItem : queryColumnArray) {
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            FormTypeEnum formTypeEnum = FormBuildUtil.getFormType(column, key);
            JSONObject item = new JSONObject();
            item.put("model", (Object)key.replace('.', '_'));
            item.put("type", (Object)formTypeEnum.getValue());
            item.put("name", (Object)column.getString("title"));
            FormBuildUtil.buildFileRes(column, formTypeEnum, item);
            if (column.has("selectKey")) {
                Object selectKey = column.get("selectKey");
                if (selectKey instanceof JSONArray) {
                    item.put("keys", selectKey);
                } else {
                    item.put("keyName", selectKey);
                }
            }
            FormBuildUtil.buildRuleAndPlaceholder(column, key, item);
            item.put("addOrEdit", (Object)AddOrEditTypeEnum.ALL.getValue());
            item.put("isOnlyAddOrEdit", true);
            formItemArray.put((Object)item);
        }
        JSONObject columnResult = new JSONObject();
        columnResult.put("formJson", (Object)formItemArray);
        return columnResult;
    }
}

